/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.cytoscape.view.presentation.property.values.Justification;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.presentation.property.values.Position;

public class ObjectPlacerGraphic
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = -1091948204116900740L;
    protected static final String OBJECT_POSITION_CHANGED = "OBJECT_POSITION_CHANGED";
    private ObjectPosition p;
    private static final int DEFAULT_WINDOW_SIZE = 500;
    private static final double GRAVITY_DISTANCE = 10.0;
    private final Color BG_COLOR = UIManager.getColor("TextField.background");
    private final Color LABEL_BOX_FG_COLOR = UIManager.getColor("CyColor.complement(-2)");
    private final Color LABEL_BOX_BG_COLOR = new Color(this.LABEL_BOX_FG_COLOR.getRed(), this.LABEL_BOX_FG_COLOR.getGreen(), this.LABEL_BOX_FG_COLOR.getBlue(), 30);
    private final Color NODE_BOX_FG_COLOR = UIManager.getColor("CyColor.complement(+1)");
    private final Color NODE_BOX_BG_COLOR = new Color(this.NODE_BOX_FG_COLOR.getRed(), this.NODE_BOX_FG_COLOR.getGreen(), this.NODE_BOX_FG_COLOR.getBlue(), 30);
    private final Color POINT_HIGHLIGHT_COLOR = UIManager.getColor("CyColor.primary(+2)");
    private int center;
    private float offsetRatio;
    private int nxy;
    private int[] npoints;
    private int lx;
    private int ly;
    private int[] lxpoints;
    private int[] lypoints;
    private int dot;
    private int xPos;
    private int yPos;
    private int bestLabelX = 1;
    private int bestLabelY = 1;
    private int bestNodeX = 1;
    private int bestNodeY = 1;
    private boolean beenDragged;
    private boolean canOffsetDrag;
    private int xClickOffset;
    private int yClickOffset;
    private int xOffset;
    private int yOffset;
    private Justification justify;
    private boolean renderDetail;
    private String objectLabel = "LABEL";
    private String targetLabel = "NODE";
    private String click = "(click and drag)";
    private int labelLen;
    private int clickLen;
    private int ascent;
    private int detailStrokeWidth = 3;
    private int lowStrokeWidth = 1;
    private final Stroke detailStroke = new BasicStroke(this.detailStrokeWidth);
    private final Stroke lowStroke = new BasicStroke(this.lowStrokeWidth);
    private Integer graphicSize;

    public ObjectPlacerGraphic(Integer graphicSize, boolean fullDetail, String objectName) {
        this.p = new ObjectPosition();
        this.objectLabel = objectName;
        this.renderDetail = fullDetail;
        this.graphicSize = graphicSize;
        if (graphicSize == null) {
            this.initSize(500);
        } else {
            this.initSize(graphicSize);
        }
        this.setBackground(this.BG_COLOR);
        this.addMouseListener(new MouseClickHandler());
        this.addMouseMotionListener(new MouseDragHandler());
        this.applyPosition();
        this.repaint();
    }

    public void setObjectPosition(ObjectPosition op) {
        this.p = op;
    }

    private void initSize(int size) {
        this.setMinimumSize(new Dimension(size, size));
        this.setPreferredSize(new Dimension(size, size));
        this.center = size / 2;
        this.offsetRatio = (float)size / 500.0f;
        this.nxy = (int)(0.3 * (double)size);
        int[] tnpoints = new int[]{this.center - this.nxy / 2, this.center, this.center + this.nxy / 2};
        this.npoints = tnpoints;
        this.lx = (int)(0.4 * (double)size);
        this.ly = (int)(0.1 * (double)size);
        int[] tlxpoints = new int[]{0, this.lx / 2, this.lx};
        int[] tlypoints = new int[]{0, this.ly / 2, this.ly};
        this.lxpoints = tlxpoints;
        this.lypoints = tlypoints;
        this.xPos = this.dot = (int)(0.02 * (double)size);
        this.yPos = this.dot;
    }

    @Override
    public void paint(Graphics gin) {
        int j;
        int i;
        int w = this.graphicSize != null ? this.graphicSize : this.getSize().width;
        int h = this.graphicSize != null ? this.graphicSize : this.getSize().height;
        Graphics2D g = (Graphics2D)gin;
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.labelLen <= 0) {
            FontMetrics fm = g.getFontMetrics();
            this.labelLen = fm.stringWidth(this.objectLabel);
            this.clickLen = fm.stringWidth(this.click);
            this.ascent = fm.getMaxAscent();
        }
        g.setColor(UIManager.getColor("Table.background"));
        g.fillRect(0, 0, w, h);
        int x = this.center - this.nxy / 2;
        int y = this.center - this.nxy / 2;
        g.setColor(this.NODE_BOX_BG_COLOR);
        g.fillOval(x, y, this.nxy, this.nxy);
        if (this.renderDetail) {
            g.setStroke(this.detailStroke);
        } else {
            g.setStroke(this.lowStroke);
        }
        g.setColor(this.NODE_BOX_FG_COLOR);
        g.drawLine(x, y, x + this.nxy, y);
        g.drawLine(x + this.nxy, y, x + this.nxy, y + this.nxy);
        g.drawLine(x + this.nxy, y + this.nxy, x, y + this.nxy);
        g.drawLine(x, y + this.nxy, x, y);
        if (this.renderDetail) {
            g.drawString(this.targetLabel, this.center - this.nxy / 12, this.center - this.nxy / 6);
            for (i = 0; i < this.npoints.length; ++i) {
                for (j = 0; j < this.npoints.length; ++j) {
                    if (i == this.bestNodeX && j == this.bestNodeY && !this.beenDragged) {
                        g.setColor(this.POINT_HIGHLIGHT_COLOR);
                    } else {
                        g.setColor(this.NODE_BOX_FG_COLOR);
                    }
                    g.fillOval(this.npoints[i] - this.dot / 2, this.npoints[j] - this.dot / 2, this.dot, this.dot);
                }
            }
        }
        g.setColor(this.LABEL_BOX_BG_COLOR);
        g.fillRect(this.xOffset + this.xPos, this.yOffset + this.yPos, this.lx, this.ly);
        g.setColor(this.LABEL_BOX_FG_COLOR);
        g.drawLine(this.xOffset + this.xPos, this.yOffset + this.yPos, this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos);
        g.drawLine(this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos, this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos + this.ly);
        g.drawLine(this.xOffset + this.xPos + this.lx, this.yOffset + this.yPos + this.ly, this.xOffset + this.xPos, this.yOffset + this.yPos + this.ly);
        g.drawLine(this.xOffset + this.xPos, this.yOffset + this.yPos + this.ly, this.xOffset + this.xPos, this.yOffset + this.yPos);
        if (this.renderDetail) {
            int vspace = (this.ly - this.ascent - this.ascent) / 3;
            if (this.justify == Justification.JUSTIFY_LEFT) {
                g.drawString(this.objectLabel, this.xOffset + this.xPos + this.detailStrokeWidth, this.yOffset + this.yPos + vspace + this.ascent);
                g.drawString(this.click, this.xOffset + this.xPos + this.detailStrokeWidth, this.yOffset + this.yPos + 2 * (vspace + this.ascent));
            } else if (this.justify == Justification.JUSTIFY_RIGHT) {
                g.drawString(this.objectLabel, this.xOffset + this.xPos + (this.lx - this.labelLen), this.yOffset + this.yPos + vspace + this.ascent);
                g.drawString(this.click, this.xOffset + this.xPos + (this.lx - this.clickLen), this.yOffset + this.yPos + 2 * (vspace + this.ascent));
            } else {
                g.drawString(this.objectLabel, this.xOffset + this.xPos + (this.lx - this.labelLen) / 2 - this.detailStrokeWidth, this.yOffset + this.yPos + vspace + this.ascent);
                g.drawString(this.click, this.xOffset + this.xPos + (this.lx - this.clickLen) / 2 - this.detailStrokeWidth, this.yOffset + this.yPos + 2 * (vspace + this.ascent));
            }
        }
        if (this.renderDetail) {
            g.setColor(this.LABEL_BOX_FG_COLOR);
            for (i = 0; i < this.lxpoints.length; ++i) {
                for (j = 0; j < this.lypoints.length; ++j) {
                    if (i == this.bestLabelX && j == this.bestLabelY && !this.beenDragged) {
                        g.setColor(this.POINT_HIGHLIGHT_COLOR);
                    }
                    g.fillOval(this.xPos + this.xOffset + this.lxpoints[i] - this.dot / 2, this.yPos + this.yOffset + this.lypoints[j] - this.dot / 2, this.dot, this.dot);
                    if (i != this.bestLabelX || j != this.bestLabelY) continue;
                    g.setColor(this.LABEL_BOX_FG_COLOR);
                }
            }
        }
    }

    public void applyPosition() {
        Position labelAnchor;
        this.xOffset = (int)(this.p.getOffsetX() * (double)this.offsetRatio);
        this.yOffset = (int)(this.p.getOffsetY() * (double)this.offsetRatio);
        this.justify = this.p.getJustify();
        Position nodeAnchor = this.p.getTargetAnchor();
        if (nodeAnchor != Position.NONE) {
            this.bestNodeX = nodeAnchor.ordinal() % 3;
            this.bestNodeY = nodeAnchor.ordinal() / 3;
        }
        if ((labelAnchor = this.p.getAnchor()) != Position.NONE) {
            this.bestLabelX = labelAnchor.ordinal() % 3;
            this.bestLabelY = labelAnchor.ordinal() / 3;
        }
        if ((nodeAnchor != Position.NONE || labelAnchor != Position.NONE) && this.npoints != null && this.lxpoints != null && this.lypoints != null) {
            if (this.npoints.length > this.bestNodeX && this.lxpoints.length > this.bestLabelX) {
                this.xPos = this.npoints[this.bestNodeX] - this.lxpoints[this.bestLabelX];
            }
            if (this.npoints.length > this.bestNodeY && this.lypoints.length > this.bestLabelY) {
                this.yPos = this.npoints[this.bestNodeY] - this.lypoints[this.bestLabelY];
            }
        }
    }

    void setPosition(ObjectPosition p) {
        this.p = p;
        this.applyPosition();
        this.repaint();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals(OBJECT_POSITION_CHANGED)) {
            this.p = (ObjectPosition)e.getNewValue();
            this.applyPosition();
            this.repaint();
        }
    }

    private Position parsePosition(int positionConstant) {
        for (Position p : Position.values()) {
            if (p.ordinal() != positionConstant) continue;
            return p;
        }
        return null;
    }

    private class MouseDragHandler
    extends MouseMotionAdapter {
        private MouseDragHandler() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (ObjectPlacerGraphic.this.canOffsetDrag) {
                ObjectPlacerGraphic.this.xPos = e.getX() - ObjectPlacerGraphic.this.xClickOffset;
                ObjectPlacerGraphic.this.yPos = e.getY() - ObjectPlacerGraphic.this.yClickOffset;
                ObjectPlacerGraphic.this.beenDragged = true;
                ObjectPlacerGraphic.this.repaint();
            }
        }
    }

    private class MouseClickHandler
    extends MouseAdapter {
        private MouseClickHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            if (x >= ObjectPlacerGraphic.this.xPos + ObjectPlacerGraphic.this.xOffset && x <= ObjectPlacerGraphic.this.xPos + ObjectPlacerGraphic.this.xOffset + ObjectPlacerGraphic.this.lx && y >= ObjectPlacerGraphic.this.yPos + ObjectPlacerGraphic.this.yOffset && y <= ObjectPlacerGraphic.this.yPos + ObjectPlacerGraphic.this.yOffset + ObjectPlacerGraphic.this.ly) {
                ObjectPlacerGraphic.this.canOffsetDrag = true;
                ObjectPlacerGraphic.this.xClickOffset = x - ObjectPlacerGraphic.this.xPos;
                ObjectPlacerGraphic.this.yClickOffset = y - ObjectPlacerGraphic.this.yPos;
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (ObjectPlacerGraphic.this.beenDragged) {
                int x = e.getX();
                int y = e.getY();
                ObjectPlacerGraphic.this.xPos = x - ObjectPlacerGraphic.this.xClickOffset + ObjectPlacerGraphic.this.xOffset;
                ObjectPlacerGraphic.this.yPos = y - ObjectPlacerGraphic.this.yClickOffset + ObjectPlacerGraphic.this.yOffset;
                double best = Double.POSITIVE_INFINITY;
                double offX = 0.0;
                double offY = 0.0;
                for (int i = 0; i < ObjectPlacerGraphic.this.npoints.length; ++i) {
                    for (int j = 0; j < ObjectPlacerGraphic.this.npoints.length; ++j) {
                        Point nodePoint = new Point(ObjectPlacerGraphic.this.npoints[i] - ObjectPlacerGraphic.this.dot / 2, ObjectPlacerGraphic.this.npoints[j] - ObjectPlacerGraphic.this.dot / 2);
                        for (int a = 0; a < ObjectPlacerGraphic.this.lxpoints.length; ++a) {
                            for (int b = 0; b < ObjectPlacerGraphic.this.lypoints.length; ++b) {
                                Point labelPoint = new Point(ObjectPlacerGraphic.this.xPos + ObjectPlacerGraphic.this.lxpoints[a] - ObjectPlacerGraphic.this.dot / 2, ObjectPlacerGraphic.this.yPos + ObjectPlacerGraphic.this.lypoints[b] - ObjectPlacerGraphic.this.dot / 2);
                                double dist = labelPoint.distance(nodePoint);
                                if (!(dist < best)) continue;
                                best = dist;
                                ObjectPlacerGraphic.this.bestLabelX = a;
                                ObjectPlacerGraphic.this.bestLabelY = b;
                                ObjectPlacerGraphic.this.bestNodeX = i;
                                ObjectPlacerGraphic.this.bestNodeY = j;
                                offX = labelPoint.getX() - nodePoint.getX();
                                offY = labelPoint.getY() - nodePoint.getY();
                            }
                        }
                    }
                }
                ObjectPlacerGraphic.this.xPos = ObjectPlacerGraphic.this.npoints[ObjectPlacerGraphic.this.bestNodeX] - ObjectPlacerGraphic.this.lxpoints[ObjectPlacerGraphic.this.bestLabelX];
                ObjectPlacerGraphic.this.yPos = ObjectPlacerGraphic.this.npoints[ObjectPlacerGraphic.this.bestNodeY] - ObjectPlacerGraphic.this.lypoints[ObjectPlacerGraphic.this.bestLabelY];
                if (Math.sqrt(offX * offX + offY * offY) > 10.0 + (double)(ObjectPlacerGraphic.this.dot / 2)) {
                    ObjectPlacerGraphic.this.xOffset = (int)offX;
                    ObjectPlacerGraphic.this.yOffset = (int)offY;
                } else {
                    ObjectPlacerGraphic.this.xOffset = 0;
                    ObjectPlacerGraphic.this.yOffset = 0;
                }
                ObjectPlacerGraphic.this.p.setOffsetX((double)ObjectPlacerGraphic.this.xOffset);
                ObjectPlacerGraphic.this.p.setOffsetY((double)ObjectPlacerGraphic.this.yOffset);
                ObjectPlacerGraphic.this.p.setAnchor(ObjectPlacerGraphic.this.parsePosition(ObjectPlacerGraphic.this.bestLabelX + 3 * ObjectPlacerGraphic.this.bestLabelY));
                ObjectPlacerGraphic.this.p.setTargetAnchor(ObjectPlacerGraphic.this.parsePosition(ObjectPlacerGraphic.this.bestNodeX + 3 * ObjectPlacerGraphic.this.bestNodeY));
                ObjectPlacerGraphic.this.firePropertyChange(ObjectPlacerGraphic.OBJECT_POSITION_CHANGED, null, ObjectPlacerGraphic.this.p);
                ObjectPlacerGraphic.this.repaint();
                ObjectPlacerGraphic.this.beenDragged = false;
                ObjectPlacerGraphic.this.canOffsetDrag = false;
            }
        }
    }
}

