/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.ding;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.SortedSet;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cytoscape.view.presentation.property.values.Justification;
import org.cytoscape.view.presentation.property.values.ObjectPosition;
import org.cytoscape.view.presentation.property.values.Position;

public class ObjectPlacerControl
extends JPanel
implements ActionListener,
PropertyChangeListener {
    private static final long serialVersionUID = 3875032897986523443L;
    private ObjectPosition lp = new ObjectPosition();
    private JComboBox<String> justifyCombo;
    private JTextField xoffsetBox;
    private JTextField yoffsetBox;
    private JComboBox<String> nodeAnchors;
    private JComboBox<String> objAnchors;
    private boolean ignoreEvents;

    public ObjectPlacerControl() {
        SortedSet points = Position.getDisplayNames();
        JLabel nodeAnchorLabel = new JLabel("Node Anchor Points:");
        this.nodeAnchors = new JComboBox<String>(points.toArray(new String[points.size()]));
        this.nodeAnchors.addActionListener(this);
        JLabel objAnchorLabel = new JLabel("Object Anchor Points:");
        this.objAnchors = new JComboBox<String>(points.toArray(new String[points.size()]));
        this.objAnchors.addActionListener(this);
        JLabel justifyLabel = new JLabel("Label Justification:");
        String[] justifyTypes = Justification.getNames();
        this.justifyCombo = new JComboBox<String>(justifyTypes);
        this.justifyCombo.addActionListener(this);
        JLabel xoffsetLabel = new JLabel("X Offset Value (can be negative):");
        this.xoffsetBox = new JTextField("0", 8);
        this.xoffsetBox.setHorizontalAlignment(4);
        this.xoffsetBox.addActionListener(this);
        JLabel yoffsetLabel = new JLabel("Y Offset Value (can be negative):");
        this.yoffsetBox = new JTextField("0", 8);
        this.yoffsetBox.setHorizontalAlignment(4);
        this.yoffsetBox.addActionListener(this);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, true).addComponent(nodeAnchorLabel).addComponent(objAnchorLabel).addComponent(justifyLabel).addComponent(xoffsetLabel).addComponent(yoffsetLabel)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.nodeAnchors).addComponent(this.objAnchors).addComponent(this.justifyCombo).addComponent(this.xoffsetBox, -2, -1, -2).addComponent(this.yoffsetBox, -2, -1, -2)));
        layout.setVerticalGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(nodeAnchorLabel).addComponent(this.nodeAnchors)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(objAnchorLabel).addComponent(this.objAnchors)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(justifyLabel).addComponent(this.justifyCombo)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(xoffsetLabel).addComponent(this.xoffsetBox)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(yoffsetLabel).addComponent(this.yoffsetBox)));
        this.applyPosition();
    }

    void setPosition(ObjectPosition p) {
        this.lp = p;
        this.applyPosition();
    }

    void applyPosition() {
        this.ignoreEvents = true;
        Position nodeAnchor = this.lp.getTargetAnchor();
        Position labelAnchor = this.lp.getAnchor();
        if (nodeAnchor.equals((Object)Position.NONE)) {
            this.nodeAnchors.setSelectedIndex(-1);
        } else {
            this.nodeAnchors.setSelectedItem(nodeAnchor.getName());
        }
        if (labelAnchor.equals((Object)Position.NONE)) {
            this.objAnchors.setSelectedIndex(-1);
        } else {
            this.objAnchors.setSelectedItem(labelAnchor.getName());
        }
        this.justifyCombo.setSelectedItem(this.lp.getJustify().getName());
        this.xoffsetBox.setText(Integer.valueOf((int)this.lp.getOffsetX()).toString());
        this.yoffsetBox.setText(Integer.valueOf((int)this.lp.getOffsetY()).toString());
        this.ignoreEvents = false;
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.ignoreEvents) {
            return;
        }
        Object source = e.getSource();
        boolean changed = false;
        if (source == this.nodeAnchors) {
            this.lp.setTargetAnchor(Position.parse((String)this.nodeAnchors.getSelectedItem().toString()));
            changed = true;
        }
        if (source == this.objAnchors) {
            this.lp.setAnchor(Position.parse((String)this.objAnchors.getSelectedItem().toString()));
            changed = true;
        }
        if (source == this.justifyCombo) {
            this.lp.setJustify(Justification.parse((String)this.justifyCombo.getSelectedItem().toString()));
            changed = true;
        }
        if (this.getOffset(this.xoffsetBox) != this.lp.getOffsetX() || this.getOffset(this.yoffsetBox) != this.lp.getOffsetY()) {
            this.lp.setOffsetX(this.getOffset(this.xoffsetBox));
            this.lp.setOffsetY(this.getOffset(this.yoffsetBox));
            changed = true;
        }
        if (!changed) {
            return;
        }
        this.firePropertyChange("OBJECT_POSITION_CHANGED", null, this.lp);
    }

    private double getOffset(JTextField jtf) {
        try {
            double d = Double.parseDouble(jtf.getText());
            return d;
        }
        catch (Exception ex) {
            jtf.setText("0");
            return 0.0;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String type = e.getPropertyName();
        if (type.equals("OBJECT_POSITION_CHANGED") && e.getNewValue() instanceof ObjectPosition) {
            this.lp = (ObjectPosition)e.getNewValue();
            this.applyPosition();
        }
    }

    public ObjectPosition getPosition() {
        return this.lp;
    }
}

