/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.util;

import java.util.HashMap;
import java.util.Map;
import org.cytoscape.application.events.SetCurrentNetworkEvent;
import org.cytoscape.application.events.SetCurrentNetworkListener;
import org.cytoscape.diffusion.internal.util.DiffusionTable;
import org.cytoscape.model.CyNetwork;

public class DiffusionTableManager
implements SetCurrentNetworkListener {
    private DiffusionTable currentTable;
    private final Map<Long, DiffusionTable> tables = new HashMap<Long, DiffusionTable>();

    public DiffusionTable getCurrentTable() {
        return this.currentTable;
    }

    public void setCurrentTable(DiffusionTable table) {
        if (!this.tables.containsValue(table)) {
            throw new IllegalArgumentException("Table does not exist in manager.  You need to register it first.");
        }
        this.currentTable = table;
    }

    public DiffusionTable createTable(CyNetwork network) {
        DiffusionTable table = new DiffusionTable(network);
        this.tables.put(network.getSUID(), table);
        this.currentTable = table;
        return table;
    }

    public DiffusionTable getTable(Long suid) {
        if (suid == null) {
            throw new NullPointerException("Currnet network's SUID is required to get the table.");
        }
        return this.tables.get(suid);
    }

    public final void setTable(Long suid, DiffusionTable table) {
        if (suid == null) {
            throw new NullPointerException("Currnet network's SUID is required to register a table.");
        }
        if (table == null) {
            throw new NullPointerException("Tbale object is required.");
        }
        this.tables.put(suid, table);
        this.currentTable = table;
    }

    public void handleEvent(SetCurrentNetworkEvent cne) {
        CyNetwork currentNetwork = cne.getNetwork();
        if (currentNetwork == null) {
            this.currentTable = null;
            return;
        }
        if (this.tables.get(currentNetwork.getSUID()) != null) {
            this.currentTable = this.tables.get(currentNetwork.getSUID());
        }
    }

    public void removeNetwork(CyNetwork network) {
        long suid;
        if (this.currentTable != null && this.currentTable.getAssociatedNetwork() == network) {
            this.currentTable = null;
        }
        if (this.tables.containsKey(suid = network.getSUID().longValue())) {
            this.tables.remove(suid);
        }
    }
}

