/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SliderValueSetterPanel
extends JPanel {
    private static final long serialVersionUID = -6505890571956050665L;
    static final String SET_VALUE_EVENT = "VALUE_SET";
    private final JLabel label;
    private final JButton setButton;
    private final JTextField valueTextField;

    public SliderValueSetterPanel(String title) {
        this.label = new JLabel("Current " + title + ":");
        this.setButton = new JButton("Set");
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SliderValueSetterPanel.this.setButtonPressed();
            }
        });
        this.valueTextField = new JTextField();
        this.valueTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SliderValueSetterPanel.this.setButtonPressed();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)this.label, "Before");
        this.add((Component)this.valueTextField, "Center");
        this.add((Component)this.setButton, "After");
    }

    void setValue(Number value) {
        String valText = value instanceof Integer ? value.toString() : String.format("%.5f", value);
        this.valueTextField.setText(valText);
    }

    private final void setButtonPressed() {
        String value = this.valueTextField.getText();
        try {
            Double numberValue = Double.parseDouble(value);
            this.firePropertyChange(SET_VALUE_EVENT, "", numberValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "Please enter valid number.  You entered: " + value, "Invalid Number", 0);
        }
    }
}

