/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.diffusion.internal.client;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.cytoscape.diffusion.internal.task.DiffuseSelectedTask;
import org.cytoscape.diffusion.internal.task.DiffusionCallableFactory;
import org.cytoscape.property.CyProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffusionServiceClient {
    private static final String BASE_URL = "http://v3.heat-diffusion.cytoscape.io/";
    private final CyProperty<Properties> props;
    private static final Logger logger = LoggerFactory.getLogger(DiffusionServiceClient.class);
    private DiffusionCallableFactory _dcf;
    private static final long SLEEP_TIME = 1000L;

    public DiffusionServiceClient(CyProperty<Properties> props) {
        this.props = props;
        this._dcf = new DiffusionCallableFactory();
    }

    protected void setAlternateDiffusionCallableFactory(DiffusionCallableFactory dcf) {
        this._dcf = dcf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String diffuse(String cx, String inputHeatCol, Double time, DiffuseSelectedTask task) throws IOException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        try {
            String theURL = ((Properties)this.props.getProperties()).getProperty("diffusion.url", BASE_URL);
            Future futureTask = executor.submit(this._dcf.getDiffusionCallable(cx, inputHeatCol, time, theURL));
            while (true) {
                try {
                    if (futureTask.isDone()) break;
                    if (task != null && task.isCanceled()) {
                        futureTask.cancel(true);
                        String string = null;
                        return string;
                    }
                }
                catch (InterruptedException ie) {
                    throw new IOException("Diffusion interrupted");
                }
                catch (ExecutionException ee) {
                    throw new IOException("Error running diffusion: " + ee.getMessage());
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            String string = (String)futureTask.get();
            return string;
        }
        finally {
            executor.shutdownNow();
        }
    }
}

