/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Properties;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.TextIcon;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.slf4j.Logger;

public final class ViewUtil {
    public static final int DIVIDER_SIZE = 5;
    public static final String CY_PROPERTY_NAME = "(cyPropertyName=cytoscape3.props)";
    public static final String SHOW_NODE_EDGE_COUNT_KEY = "showNodeEdgeCount";
    public static final String SHOW_NETWORK_PROVENANCE_HIERARCHY_KEY = "showNetworkProvenanceHierarchy";
    public static final String DEFAULT_PROVIDER_PROP_KEY = "networkSearch.defaultProvider";
    public static final String PARENT_NETWORK_COLUMN = "__parentNetwork.SUID";
    public static final Border DESELECTED_TOGLLE_BORDER;
    public static final Border SELECTED_TOGLLE_BORDER;
    private static final String DEF_ICON_REGEX = "([A-Z]?[0-9a-z]+)|([A-Z]+)";
    private static final Pattern DEF_ICON_PATTERN;

    public static String getName(CyNetwork network) {
        Object name = "";
        try {
            name = (String)network.getRow((CyIdentifiable)network).get("name", String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null || ((String)name).trim().isEmpty()) {
            name = "? (SUID: " + network.getSUID() + ")";
        }
        return name;
    }

    public static String getTitle(CyNetworkView view) {
        String title = (String)view.getVisualProperty(BasicVisualLexicon.NETWORK_TITLE);
        if (title == null || title.trim().isEmpty()) {
            title = ViewUtil.getName((CyNetwork)view.getModel());
        }
        return title;
    }

    public static int getHiddenNodeCount(CyNetworkView view) {
        int count = 0;
        if (view != null) {
            for (View nv : view.getNodeViews()) {
                if (nv.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE) != Boolean.FALSE) continue;
                ++count;
            }
        }
        return count;
    }

    public static int getHiddenEdgeCount(CyNetworkView view) {
        int count = 0;
        if (view != null) {
            for (View ev : view.getEdgeViews()) {
                if (ev.getVisualProperty(BasicVisualLexicon.EDGE_VISIBLE) != Boolean.FALSE) continue;
                ++count;
            }
        }
        return count;
    }

    public static String createUniqueKey(CyNetworkView view) {
        return "__CyNetworkView_" + view.getSUID();
    }

    public static String createUniqueKey(CyNetwork net) {
        return "__CyNetwork_" + (Serializable)(net != null ? net.getSUID() : "null");
    }

    public static CySubNetwork getParent(CySubNetwork net, CyServiceRegistrar serviceRegistrar) {
        CyNetwork parent;
        Long suid;
        CyTable hiddenTable = net.getTable(CyNetwork.class, "HIDDEN");
        CyRow row = hiddenTable != null ? hiddenTable.getRow((Object)net.getSUID()) : null;
        Long l = suid = row != null ? (Long)row.get(PARENT_NETWORK_COLUMN, Long.class) : null;
        if (suid != null && (parent = ((CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class)).getNetwork(suid.longValue())) instanceof CySubNetwork) {
            return (CySubNetwork)parent;
        }
        return null;
    }

    public static void styleToolBarButton(AbstractButton btn) {
        ViewUtil.styleToolBarButton(btn, null, true);
    }

    public static void styleToolBarButton(AbstractButton btn, boolean addPadding) {
        ViewUtil.styleToolBarButton(btn, null, addPadding);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font) {
        ViewUtil.styleToolBarButton(btn, font, true);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font, boolean addPadding) {
        int hPad = addPadding ? 5 : 0;
        int vPad = addPadding ? 4 : 0;
        ViewUtil.styleToolBarButton(btn, font, hPad, vPad);
    }

    public static void styleToolBarButton(AbstractButton btn, Font font, int hPad, int vPad) {
        if (font != null) {
            btn.setFont(font);
        }
        btn.setFocusPainted(false);
        btn.setFocusable(false);
        btn.setBorder(BorderFactory.createEmptyBorder());
        btn.setContentAreaFilled(false);
        btn.setOpaque(true);
        btn.setHorizontalTextPosition(0);
        btn.setVerticalTextPosition(1);
        if (hPad > 0 || vPad > 0) {
            Dimension d = btn.getPreferredSize();
            d = new Dimension(d.width + 2 * hPad, d.height + 2 * vPad);
            btn.setPreferredSize(d);
            btn.setMinimumSize(d);
            btn.setMaximumSize(d);
            btn.setSize(d);
        }
        if (btn instanceof JToggleButton) {
            btn.addItemListener(evt -> ViewUtil.updateToolBarStyle((JToggleButton)btn));
            ViewUtil.updateToolBarStyle((JToggleButton)btn);
        }
    }

    public static void updateToolBarStyle(JToggleButton btn) {
        ViewUtil.updateToolBarStyle(btn, true);
    }

    public static void updateToolBarStyle(JToggleButton btn, boolean showSelectionBorder) {
        Border defBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        if (btn.isEnabled()) {
            Border selBorder = showSelectionBorder ? BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("CyToggleButton[Selected].borderColor")), BorderFactory.createEmptyBorder(1, 1, 1, 1)) : defBorder;
            btn.setBorder(btn.isSelected() ? selBorder : defBorder);
            btn.setBackground(btn.isSelected() ? UIManager.getColor("CyToggleButton[Selected].background") : UIManager.getColor("CyToggleButton.background"));
            btn.setForeground(btn.isSelected() ? UIManager.getColor("CyToggleButton[Selected].foreground") : UIManager.getColor("CyToggleButton.foreground"));
        } else {
            btn.setBorder(defBorder);
            btn.setForeground(UIManager.getColor("ToggleButton.disabledForeground"));
            btn.setBackground(UIManager.getColor("CyToggleButton.unselectedBackground"));
        }
    }

    public static JSeparator createToolBarSeparator() {
        ToolBarSeparator sep = new ToolBarSeparator(1);
        sep.setForeground(UIManager.getColor("Separator.foreground"));
        return sep;
    }

    public static Icon resizeIcon(Icon icon, int maxHeight) {
        int height = icon.getIconHeight();
        int width = icon.getIconWidth();
        if (height <= maxHeight) {
            return icon;
        }
        int newHeight = maxHeight;
        int newWidth = Math.round((float)width * ((float)newHeight / (float)height));
        BufferedImage img = new BufferedImage(width, height, 2);
        Graphics2D g = img.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        Image resizedImage = img.getScaledInstance(newWidth, newHeight, 4);
        ImageIcon resizedIcon = new ImageIcon(resizedImage);
        return resizedIcon;
    }

    public static String getViewProperty(String key, CyServiceRegistrar serviceRegistrar) {
        return ViewUtil.getViewProperty(key, null, serviceRegistrar);
    }

    public static String getViewProperty(String key, String defaultValue, CyServiceRegistrar serviceRegistrar) {
        CyProperty cyProps = (CyProperty)serviceRegistrar.getService(CyProperty.class, CY_PROPERTY_NAME);
        return ((Properties)cyProps.getProperties()).getProperty(key, defaultValue);
    }

    public static void setViewProperty(String key, String value, CyServiceRegistrar serviceRegistrar) {
        CyProperty cyProps = (CyProperty)serviceRegistrar.getService(CyProperty.class, CY_PROPERTY_NAME);
        ((Properties)cyProps.getProperties()).setProperty(key, value);
    }

    public static Rectangle getEffectiveScreenArea(GraphicsConfiguration gc) {
        Rectangle bounds = gc.getBounds();
        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
        Rectangle rect = new Rectangle();
        rect.x = bounds.x + screenInsets.left;
        rect.y = bounds.y + screenInsets.top;
        rect.height = bounds.height - screenInsets.top - screenInsets.bottom;
        rect.width = bounds.width - screenInsets.left - screenInsets.right;
        return rect;
    }

    public static Window getWindowAncestor(ActionEvent evt, CySwingApplication swingApplication) {
        Window window = null;
        if (evt.getSource() instanceof JMenuItem) {
            if (swingApplication.getJMenuBar() != null) {
                window = SwingUtilities.getWindowAncestor(swingApplication.getJMenuBar());
            }
        } else if (evt.getSource() instanceof Component) {
            window = SwingUtilities.getWindowAncestor((Component)evt.getSource());
        }
        if (window == null) {
            window = swingApplication.getJFrame();
        }
        return window;
    }

    public static void recursiveDo(Component component, Consumer<JComponent> c) {
        if (component instanceof JComponent) {
            c.accept((JComponent)component);
        }
        if (component instanceof Container) {
            for (Component child : ((Container)component).getComponents()) {
                ViewUtil.recursiveDo(child, c);
            }
        }
    }

    public static void makeSmall(JComponent ... components) {
        if (components == null || components.length == 0) {
            return;
        }
        for (JComponent c : components) {
            if (LookAndFeelUtil.isAquaLAF()) {
                c.putClientProperty("JComponent.sizeVariant", "small");
            } else if (c.getFont() != null) {
                c.setFont(c.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
            }
            if (c instanceof JList) {
                ((JList)c).setCellRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                        this.setFont(this.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
                        return this;
                    }
                });
                continue;
            }
            if (!(c instanceof JMenuItem)) continue;
            c.setFont(c.getFont().deriveFont(LookAndFeelUtil.getSmallFontSize()));
        }
    }

    public static boolean hasVisibleOwnedWindows(Window window) {
        Window[] ownedWindows;
        Window[] windowArray = ownedWindows = window != null ? window.getOwnedWindows() : null;
        if (ownedWindows == null || ownedWindows.length == 0) {
            return false;
        }
        for (Window w : ownedWindows) {
            if (!w.isVisible()) continue;
            return true;
        }
        return false;
    }

    public static void invokeOnEDT(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public static void invokeOnEDTAndWait(Runnable runnable) {
        ViewUtil.invokeOnEDTAndWait(runnable, null);
    }

    public static void invokeOnEDTAndWait(Runnable runnable, Logger logger) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception e) {
                if (logger != null) {
                    logger.error("Unexpected error", (Throwable)e);
                }
                e.printStackTrace();
            }
        }
    }

    public static boolean isScreenMenuBar() {
        return LookAndFeelUtil.isAquaLAF() && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
    }

    public static Icon createDefaultIcon(String title, int size, IconManager iconManager) {
        String text = ViewUtil.createDefaultIconText(title);
        Color iconColor = ViewUtil.getDefaultIconColor(title);
        Color textColor = ViewUtil.getContrastingColor(iconColor);
        String shape = text.length() > 1 ? "\uf0c8" : "\uf111";
        Font iconFont = iconManager.getIconFont((float)size * 1.125f);
        int fontSize = (int)Math.round((double)size / (text.length() > 1 ? 1.6 : 1.3));
        Font textFont = new Font("Monospaced", 1, fontSize);
        return new TextIcon(new String[]{shape, text}, new Font[]{iconFont, textFont}, new Color[]{iconColor, textColor}, size, size);
    }

    public static Color getContrastingColor(Color color) {
        int d = 0;
        double a = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        d = a < 0.5 ? 0 : 255;
        return new Color(d, d, d);
    }

    static String createDefaultIconText(String title) {
        Object text = "";
        if (!(title = title.trim()).isEmpty()) {
            Matcher matcher = DEF_ICON_PATTERN.matcher(title);
            block0: while (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    String s = matcher.group(i);
                    String string = s = s != null ? s.trim() : "";
                    if (!s.isEmpty()) {
                        text = (String)text + s.substring(0, 1);
                    }
                    if (((String)text).length() == 2) break block0;
                }
            }
            if (((String)text).isEmpty()) {
                text = title.substring(0, 1);
            }
        }
        return ((String)text).isEmpty() ? (text = " ") : text;
    }

    private static Color getDefaultIconColor(String text) {
        int index = Math.abs(text.toLowerCase().hashCode() % 7);
        switch (index) {
            default: {
                return new Color(55, 126, 184);
            }
            case 1: {
                return new Color(77, 175, 74);
            }
            case 2: {
                return new Color(152, 78, 163);
            }
            case 3: {
                return new Color(255, 127, 0);
            }
            case 4: {
                return new Color(255, 255, 51);
            }
            case 5: {
                return new Color(166, 86, 40);
            }
            case 6: 
        }
        return new Color(247, 129, 191);
    }

    private ViewUtil() {
    }

    static {
        SELECTED_TOGLLE_BORDER = DESELECTED_TOGLLE_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        DEF_ICON_PATTERN = Pattern.compile(DEF_ICON_REGEX);
    }

    private static class ToolBarSeparator
    extends JSeparator {
        ToolBarSeparator(int orientation) {
            super(orientation);
        }

        @Override
        public void paint(Graphics g) {
            Dimension s = this.getSize();
            if (this.getOrientation() == 1) {
                g.setColor(this.getForeground());
                g.drawLine(0, 0, 0, s.height);
            } else {
                g.setColor(this.getForeground());
                g.drawLine(0, 0, s.width, 0);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.getOrientation() == 1) {
                return new Dimension(1, 0);
            }
            return new Dimension(0, 1);
        }
    }
}

