/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view.util;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.plaf.basic.BasicButtonUI;

public class VerticalButtonUI
extends BasicButtonUI {
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle();
    private static Insets viewInsets = new Insets(0, 0, 0, 0);
    protected boolean clockwise;

    public VerticalButtonUI() {
        this(false);
    }

    public VerticalButtonUI(boolean clockwise) {
        this.clockwise = clockwise;
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = super.getPreferredSize(c);
        return new Dimension(dim.height, dim.width);
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        Icon icon;
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon icon2 = icon = b.isEnabled() ? b.getIcon() : b.getDisabledIcon();
        if (icon == null && text == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g.create();
        FontMetrics fm = g2.getFontMetrics();
        viewInsets = b.getInsets(viewInsets);
        VerticalButtonUI.viewRect.x = VerticalButtonUI.viewInsets.left;
        VerticalButtonUI.viewRect.y = VerticalButtonUI.viewInsets.top;
        VerticalButtonUI.viewRect.height = b.getWidth() - (VerticalButtonUI.viewInsets.left + VerticalButtonUI.viewInsets.right);
        VerticalButtonUI.viewRect.width = b.getHeight() - (VerticalButtonUI.viewInsets.top + VerticalButtonUI.viewInsets.bottom);
        Rectangle2D strBounds = text != null ? fm.getStringBounds(text, g2) : new Rectangle2D.Double();
        VerticalButtonUI.iconRect.x = (int)Math.round(((double)(VerticalButtonUI.viewRect.width - icon.getIconWidth() - b.getIconTextGap()) - strBounds.getWidth()) / 2.0);
        VerticalButtonUI.iconRect.y = VerticalButtonUI.viewRect.y + Math.round((float)(VerticalButtonUI.viewRect.height - icon.getIconHeight()) / 2.0f);
        VerticalButtonUI.iconRect.width = icon.getIconWidth();
        VerticalButtonUI.iconRect.height = icon.getIconHeight();
        if (text != null) {
            VerticalButtonUI.textRect.x = VerticalButtonUI.iconRect.x + VerticalButtonUI.iconRect.width + b.getIconTextGap();
            VerticalButtonUI.textRect.y = VerticalButtonUI.viewRect.y + (int)Math.round(((double)VerticalButtonUI.viewRect.height - strBounds.getHeight()) / 2.0);
            VerticalButtonUI.textRect.width = (int)strBounds.getWidth();
            VerticalButtonUI.textRect.height = (int)strBounds.getHeight();
        }
        if (this.clockwise) {
            g2.rotate(1.5707963267948966);
            g2.translate(0, -b.getWidth());
        } else {
            g2.rotate(-1.5707963267948966);
            g2.translate(-b.getHeight(), 0);
        }
        if (icon != null) {
            icon.paintIcon(b, g2, VerticalButtonUI.iconRect.x, VerticalButtonUI.iconRect.y);
        }
        if (text != null) {
            this.paintText((Graphics)g2, b, textRect, text);
        }
        g2.dispose();
    }
}

