/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;

public class ToggleableButtonGroup
extends ButtonGroup {
    private ButtonModel lastModel;
    private boolean toggleable;

    public ToggleableButtonGroup() {
        this(false);
    }

    public ToggleableButtonGroup(boolean toggleable) {
        this.toggleable = toggleable;
    }

    @Override
    public void add(AbstractButton button) {
        if (button == null || this.buttons.contains(button)) {
            return;
        }
        super.add(button);
        if (this.getSelection() == button.getModel() && this.toggleable) {
            this.lastModel = button.getModel();
        }
    }

    public void add(Collection<? extends AbstractButton> buttons) {
        if (buttons == null) {
            return;
        }
        for (AbstractButton abstractButton : buttons) {
            this.add(abstractButton);
        }
    }

    @Override
    public void remove(AbstractButton button) {
        if (button == null || !this.buttons.contains(button)) {
            return;
        }
        if (this.toggleable && this.lastModel == button.getModel()) {
            this.lastModel = null;
        }
        super.remove(button);
    }

    public void remove(Collection<? extends AbstractButton> buttons) {
        if (buttons == null) {
            return;
        }
        for (AbstractButton abstractButton : buttons) {
            this.remove(abstractButton);
        }
    }

    public void setSelected(AbstractButton button, boolean selected) {
        if (button != null && this.buttons.contains(button)) {
            this.setSelected(button.getModel(), selected);
        }
    }

    @Override
    public void setSelected(ButtonModel model, boolean selected) {
        AbstractButton button = this.getButton(model);
        if (button == null) {
            return;
        }
        if (this.toggleable) {
            if (model == this.lastModel) {
                this.clearSelection();
            } else if (this.buttons.contains(button) && selected != this.isSelected(model)) {
                super.setSelected(model, selected);
            }
            this.lastModel = this.getSelection();
        } else if (this.buttons.contains(button) && selected != this.isSelected(model)) {
            super.setSelected(model, selected);
        }
    }

    public AbstractButton getButton(ButtonModel model) {
        for (AbstractButton ab : this.buttons) {
            if (ab.getModel() != model) continue;
            return ab;
        }
        return null;
    }

    public AbstractButton getSelectedButton() {
        return this.getSelection() != null ? this.getButton(this.getSelection()) : null;
    }

    public boolean isSelected(AbstractButton button) {
        return button.getModel() == this.getSelection();
    }

    public List<AbstractButton> getButtons() {
        return Collections.unmodifiableList(this.buttons);
    }

    public boolean contains(AbstractButton button) {
        return this.buttons.contains(button);
    }
}

