/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view.updater;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.LayoutStyle;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.OpenBrowser;

public class UpdatesDialog
extends JDialog {
    private static final String DOWNLOAD_URL = "http://cytoscape.org/download.php";
    private JPanel statusPanel;
    private JCheckBox checkBox;
    private JButton downloadButton;
    private JButton closeButton;
    private final JLabel statusIconLabel = new JLabel();
    private final JLabel statusLabel = new JLabel();
    private final String thisVersion;
    private final String latestVersion;
    private final boolean hideOptionVisible;
    private final CyServiceRegistrar serviceRegistrar;

    public UpdatesDialog(Window owner, String thisVersion, String latestVersion, boolean hideOptionVisible, CyServiceRegistrar serviceRegistrar) {
        super(owner);
        this.thisVersion = thisVersion;
        this.latestVersion = latestVersion;
        this.hideOptionVisible = hideOptionVisible;
        this.serviceRegistrar = serviceRegistrar;
        this.initComponents();
    }

    public boolean getHideStatus() {
        return this.getCheckBox().isSelected();
    }

    private void initComponents() {
        this.setResizable(false);
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        boolean downloadEnabled = false;
        if (this.thisVersion != null && this.latestVersion != null) {
            if (this.thisVersion.equals(this.latestVersion)) {
                this.statusIconLabel.setText("\uf05a");
                this.statusIconLabel.setForeground(LookAndFeelUtil.getInfoColor());
                this.statusLabel.setText("Cytoscape is up to date!");
            } else if (this.thisVersion.contains("-")) {
                this.statusIconLabel.setText("\uf05a");
                this.statusIconLabel.setForeground(LookAndFeelUtil.getInfoColor());
                this.statusLabel.setText("This is a pre-release version of Cytoscape.");
            } else {
                this.statusIconLabel.setText("\uf0ab");
                this.statusIconLabel.setForeground(LookAndFeelUtil.getInfoColor());
                this.statusLabel.setText("<html><p>A new version of Cytoscape is available!</p><p>Would you like to download version " + this.latestVersion + "?</p></html>");
                downloadEnabled = true;
            }
        } else {
            this.statusIconLabel.setText("\uf071");
            this.statusIconLabel.setForeground(LookAndFeelUtil.getErrorColor());
            this.statusLabel.setText("Unable to get current version. Are you connected to the internet?");
        }
        JPanel bottomPanel = downloadEnabled ? LookAndFeelUtil.createOkCancelPanel((JButton)this.getDownloadButton(), (JButton)this.getCloseButton()) : LookAndFeelUtil.createOkCancelPanel(null, (JButton)this.getCloseButton());
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(!LookAndFeelUtil.isAquaLAF());
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.getStatusPanel(), -1, -1, Short.MAX_VALUE).addComponent(bottomPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getStatusPanel(), -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(bottomPanel, -2, -1, -2));
        if (downloadEnabled) {
            LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getDownloadButton().getAction(), (Action)this.getCloseButton().getAction());
            this.getRootPane().setDefaultButton(this.getDownloadButton());
            this.getDownloadButton().requestFocusInWindow();
        } else {
            LookAndFeelUtil.setDefaultOkCancelKeyStrokes((JRootPane)this.getRootPane(), (Action)this.getCloseButton().getAction(), (Action)this.getCloseButton().getAction());
            this.getRootPane().setDefaultButton(this.getCloseButton());
        }
    }

    private JPanel getStatusPanel() {
        if (this.statusPanel == null) {
            this.statusPanel = new JPanel();
            this.statusPanel.setName("StatusPanel");
            this.statusIconLabel.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(36.0f));
            int hpad = 20;
            int vpad = 40;
            GroupLayout layout = new GroupLayout(this.statusPanel);
            this.statusPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(20).addComponent(this.statusIconLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(this.statusLabel, -1, -1, Short.MAX_VALUE).addComponent(this.getCheckBox(), -2, -1, -2)).addGap(20, 20, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addGap(40).addComponent(this.statusIconLabel, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.statusLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getCheckBox(), -2, -1, -2)).addGap(40));
        }
        return this.statusPanel;
    }

    private JCheckBox getCheckBox() {
        if (this.checkBox == null) {
            this.checkBox = new JCheckBox("Do not remind me again for this version");
            this.checkBox.setHorizontalAlignment(2);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.checkBox});
            this.checkBox.setVisible(this.hideOptionVisible);
        }
        return this.checkBox;
    }

    private JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton(new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdatesDialog.this.dispose();
                }
            });
        }
        return this.closeButton;
    }

    private JButton getDownloadButton() {
        if (this.downloadButton == null) {
            this.downloadButton = new JButton(new AbstractAction("Download Now"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UpdatesDialog.this.dispose();
                    ((OpenBrowser)UpdatesDialog.this.serviceRegistrar.getService(OpenBrowser.class)).openURL(UpdatesDialog.DOWNLOAD_URL);
                }
            });
        }
        return this.downloadButton;
    }
}

