/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.internal.util.Util;
import org.cytoscape.internal.view.CytoPanelUtil;
import org.cytoscape.io.util.RecentlyOpenedTracker;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;
import org.cytoscape.util.swing.OpenBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StarterPanel
extends JPanel {
    public static String NAME = "__STARTER_PANEL__";
    public static final String TUTORIAL_URL = "http://tutorials.cytoscape.org";
    public static final String NEWS_URL = "http://cytoscape-publications.tumblr.com";
    public final Color LIST_BG_COLOR = UIManager.getColor("Table.background");
    public final Color LIST_FOCUS_BG_COLOR = UIManager.getColor("Table.selectionBackground");
    public final Color LINK_FONT_COLOR = UIManager.getColor("Table.focusCellBackground");
    private static final int PANEL_PAD = 4;
    private static final int V_GAP = 10;
    private static final int BORDER_WIDTH = 2;
    private final Border DEF_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    private final Border FOCUS_BORDER = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getColor("Focus.color"), 1), BorderFactory.createLineBorder(this.LIST_FOCUS_BG_COLOR, 1));
    private static final String SAMPLE_DATA_DIR = "sampleData/sessions";
    private static final String SESSION_EXT = ".cys";
    private static final int MAX_FILES = 100;
    private static final String MISSING_IMAGE = "/images/logo-light-96.png";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private JPanel contentPane;
    private SessionListPanel recentSessionsPanel;
    private SessionListPanel sampleSessionsPanel;
    private JPanel titlePanel;
    private JPanel linksPanel;
    private JButton closeButton;
    private JLabel tutorialsLabel = this.createLinkLabel("<html><u>Tutorials</u></html>", "http://tutorials.cytoscape.org");
    private JLabel newsLabel = this.createLinkLabel("<html><u>News</u></html>", "http://cytoscape-publications.tumblr.com");
    private final Icon missingImageIcon;
    private final CyServiceRegistrar serviceRegistrar;

    public StarterPanel(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.missingImageIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(MISSING_IMAGE)));
        this.setName(NAME);
        this.init();
        this.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            int w = 8 + Math.max(this.getRecentSessionsPanel().getPreferredSize().width, this.getSampleSessionsPanel().getPreferredSize().width);
            int h = 8 + this.getTitlePanel().getPreferredSize().height + this.getRecentSessionsPanel().getPreferredSize().height + 10 + this.getSampleSessionsPanel().getPreferredSize().height + this.getLinksPanel().getPreferredSize().height;
            return new Dimension(w, h);
        }
    }

    public void update() {
        List<FileInfo> recentFiles = this.getRecentFiles();
        this.getRecentSessionsPanel().update(recentFiles);
        this.getRecentSessionsPanel().setVisible(!recentFiles.isEmpty());
        this.getSampleSessionsPanel().update(this.getSampleFiles());
    }

    private void init() {
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(new BorderLayout());
        this.add((Component)this.getTitlePanel(), "North");
        this.add((Component)this.getContentPane(), "Center");
        this.add((Component)this.getLinksPanel(), "South");
    }

    public JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setOpaque(false);
            GroupLayout layout = new GroupLayout(this.contentPane);
            this.contentPane.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getRecentSessionsPanel(), -1, -1, Short.MAX_VALUE).addComponent(this.getSampleSessionsPanel(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getRecentSessionsPanel(), -1, -1, Short.MAX_VALUE).addGap(10).addComponent(this.getSampleSessionsPanel(), -1, -1, Short.MAX_VALUE));
        }
        return this.contentPane;
    }

    private JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
            this.titlePanel.setOpaque(false);
            JLabel titleLabel = new JLabel("Welcome to Cytoscape");
            titleLabel.setHorizontalAlignment(0);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{titleLabel});
            GroupLayout layout = new GroupLayout(this.titlePanel);
            this.titlePanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(false);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(this.getCloseButton().getPreferredSize().width).addComponent(titleLabel, -1, -1, Short.MAX_VALUE).addComponent(this.getCloseButton(), -2, -1, -2));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(titleLabel, -2, -1, -2).addComponent(this.getCloseButton(), -2, -1, -2));
        }
        return this.titlePanel;
    }

    private SessionListPanel getRecentSessionsPanel() {
        if (this.recentSessionsPanel == null) {
            this.recentSessionsPanel = new SessionListPanel("Recent Sessions");
        }
        return this.recentSessionsPanel;
    }

    private SessionListPanel getSampleSessionsPanel() {
        if (this.sampleSessionsPanel == null) {
            this.sampleSessionsPanel = new SessionListPanel("Sample Sessions");
        }
        return this.sampleSessionsPanel;
    }

    private JPanel getLinksPanel() {
        if (this.linksPanel == null) {
            this.linksPanel = new JPanel();
            this.linksPanel.setOpaque(false);
            LookAndFeelUtil.equalizeSize((JComponent[])new JComponent[]{this.tutorialsLabel, this.newsLabel});
            GroupLayout layout = new GroupLayout(this.linksPanel);
            this.linksPanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(true);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.tutorialsLabel, -2, -1, -2).addGap(80).addComponent(this.newsLabel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.tutorialsLabel, -2, -1, -2).addComponent(this.newsLabel, -2, -1, -2));
        }
        return this.linksPanel;
    }

    JButton getCloseButton() {
        if (this.closeButton == null) {
            this.closeButton = new JButton("\uf00d");
            this.closeButton.setToolTipText("Hide Starter Panel");
            CytoPanelUtil.styleButton(this.closeButton);
            this.closeButton.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(13.0f));
            this.closeButton.setSelected(true);
        }
        return this.closeButton;
    }

    private JLabel createLinkLabel(String text, final String url) {
        JLabel label = new JLabel(text);
        label.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        label.setForeground(this.LINK_FONT_COLOR);
        label.setHorizontalAlignment(0);
        label.setCursor(new Cursor(12));
        label.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    ((OpenBrowser)StarterPanel.this.serviceRegistrar.getService(OpenBrowser.class)).openURL(url);
                }
            }
        });
        return label;
    }

    private List<FileInfo> getRecentFiles() {
        ArrayList<FileInfo> files = new ArrayList<FileInfo>();
        RecentlyOpenedTracker fileTracker = (RecentlyOpenedTracker)this.serviceRegistrar.getService(RecentlyOpenedTracker.class);
        List recentFiles = fileTracker.getRecentlyOpenedURLs();
        int fileCount = Math.min(recentFiles.size(), 100);
        for (int i = 0; i < fileCount; ++i) {
            URL url = (URL)recentFiles.get(i);
            File file = null;
            try {
                URI uri = url.toURI();
                file = new File(uri);
            }
            catch (Exception e) {
                logger.error("Invalid file URL.", (Throwable)e);
                continue;
            }
            if (file.exists() && file.canRead()) {
                FileInfo fi = new FileInfo(file, file.getName(), file.getAbsolutePath());
                files.add(fi);
                continue;
            }
            fileCount = Math.min(recentFiles.size(), fileCount + 1);
        }
        return files;
    }

    private List<FileInfo> getSampleFiles() {
        File[] files;
        ArrayList<FileInfo> list = new ArrayList<FileInfo>();
        File dir = this.getExampleDir();
        if (dir != null && dir.exists() && dir.canRead() && (files = dir.listFiles()) != null) {
            for (File f : files) {
                if (!f.canRead() || !f.getName().toLowerCase().endsWith(SESSION_EXT)) continue;
                String toolTip = "<html>This (<b>" + f.getName() + "</b>) and other example files can be found in:<br />" + dir.getAbsolutePath() + "</html>";
                FileInfo fi = new FileInfo(f, f.getName().replace(SESSION_EXT, ""), toolTip);
                list.add(fi);
            }
        }
        return list;
    }

    private final File getExampleDir() {
        CyApplicationConfiguration applicationCfg = (CyApplicationConfiguration)this.serviceRegistrar.getService(CyApplicationConfiguration.class);
        if (applicationCfg != null) {
            return new File(applicationCfg.getInstallationDirectoryLocation() + "/sampleData/sessions/");
        }
        logger.error("application configuration is null, cannot find the installation directory");
        return null;
    }

    private void maybeOpenSession(File file) {
        if (file.exists()) {
            Util.maybeOpenSession(file, this.getTopLevelAncestor(), this.serviceRegistrar);
        } else {
            JOptionPane.showMessageDialog(this.getTopLevelAncestor(), "Session file not found:\n" + file.getAbsolutePath(), "File not Found", 2);
            RecentlyOpenedTracker fileTracker = (RecentlyOpenedTracker)this.serviceRegistrar.getService(RecentlyOpenedTracker.class);
            try {
                fileTracker.remove(file.toURI().toURL());
            }
            catch (Exception e) {
                logger.error("Error removing session file from RecentlyOpenedTracker.", (Throwable)e);
            }
        }
    }

    private void drawFocus(SessionPanel panel) {
        List<SessionPanel> all = this.getRecentSessionsPanel().getAllPanels();
        all.addAll(this.getSampleSessionsPanel().getAllPanels());
        for (SessionPanel p : all) {
            this.drawFocus(p, panel == p);
        }
    }

    private void drawFocus(SessionPanel panel, boolean hasFocus) {
        panel.setBorder(hasFocus ? this.FOCUS_BORDER : this.DEF_BORDER);
        panel.setBackground(hasFocus ? this.LIST_FOCUS_BG_COLOR : this.LIST_BG_COLOR);
    }

    private final class FileInfo {
        private final String THUMBNAIL_FILE = "/session_thumbnail.png";
        private final File file;
        private final String name;
        private final String help;
        private Icon icon;

        FileInfo(File file, String name, String help) {
            this.file = file;
            this.help = help;
            this.name = name;
        }

        final File getFile() {
            return this.file;
        }

        final String getName() {
            return this.name;
        }

        final String getHelp() {
            return this.help;
        }

        Icon getIcon() {
            if (this.icon == null) {
                Image thumbnail = this.loadThumbnail();
                this.icon = thumbnail != null ? new ImageIcon(thumbnail) : StarterPanel.this.missingImageIcon;
            }
            return this.icon;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Image loadThumbnail() {
            BufferedImage img = null;
            if (this.file != null && this.file.canRead()) {
                ZipFile zipFile = null;
                try {
                    zipFile = new ZipFile(this.file);
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith("/session_thumbnail.png")) continue;
                        InputStream stream = zipFile.getInputStream(entry);
                        img = ImageIO.read(stream);
                        stream.close();
                        break;
                    }
                }
                catch (Exception e) {
                    logger.error("Cannot load session thumbnail from " + this.file.getName(), (Throwable)e);
                }
                finally {
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Exception ex) {
                            logger.error("Unable to close file " + this.file.getName(), (Throwable)ex);
                        }
                    }
                }
            }
            return img;
        }

        public int hashCode() {
            int prime = 17;
            int result = 7;
            result = 17 * result + this.getOuterType().hashCode();
            result = 17 * result + (this.file == null ? 0 : this.file.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FileInfo other = (FileInfo)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.file == null ? other.file != null : !this.file.equals(other.file));
        }

        private StarterPanel getOuterType() {
            return StarterPanel.this;
        }
    }

    public class ModifiedFlowLayout
    extends FlowLayout {
        public ModifiedFlowLayout() {
        }

        public ModifiedFlowLayout(int align) {
            super(align);
        }

        public ModifiedFlowLayout(int align, int hgap, int vgap) {
            super(align, hgap, vgap);
        }

        @Override
        public Dimension minimumLayoutSize(Container target) {
            return this.computeMinSize(target);
        }

        @Override
        public Dimension preferredLayoutSize(Container target) {
            return this.computeSize(target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension computeSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                Insets insets;
                int hgap = this.getHgap();
                int vgap = this.getVgap();
                int w = target.getWidth();
                if (w == 0) {
                    w = Integer.MAX_VALUE;
                }
                if ((insets = target.getInsets()) == null) {
                    insets = new Insets(0, 0, 0, 0);
                }
                int reqdWidth = 0;
                int maxwidth = w - (insets.left + insets.right + hgap * 2);
                int n = target.getComponentCount();
                int x = 0;
                int y = insets.top + vgap;
                int rowHeight = 0;
                for (int i = 0; i < n; ++i) {
                    Component c = target.getComponent(i);
                    if (!c.isVisible()) continue;
                    Dimension d = c.getPreferredSize();
                    if (x == 0 || x + d.width <= maxwidth) {
                        if (x > 0) {
                            x += hgap;
                        }
                        x += d.width;
                        rowHeight = Math.max(rowHeight, d.height);
                    } else {
                        x = d.width;
                        y += vgap + rowHeight;
                        rowHeight = d.height;
                    }
                    reqdWidth = Math.max(reqdWidth, x);
                }
                y += rowHeight;
                return new Dimension(reqdWidth + insets.left + insets.right, y += insets.bottom);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Dimension computeMinSize(Container target) {
            Object object = target.getTreeLock();
            synchronized (object) {
                int minx = Integer.MAX_VALUE;
                int miny = Integer.MIN_VALUE;
                boolean found_one = false;
                int n = target.getComponentCount();
                for (int i = 0; i < n; ++i) {
                    Component c = target.getComponent(i);
                    if (!c.isVisible()) continue;
                    found_one = true;
                    Dimension d = c.getPreferredSize();
                    minx = Math.min(minx, d.width);
                    miny = Math.min(miny, d.height);
                }
                if (found_one) {
                    return new Dimension(minx, miny);
                }
                return new Dimension(0, 0);
            }
        }
    }

    private class SessionPanel
    extends JPanel {
        static final int NAME_WIDTH = 124;
        private JLabel thumbnailLabel;
        private JLabel nameLabel;
        private final FileInfo fileInfo;

        SessionPanel(FileInfo fileInfo) {
            this.fileInfo = fileInfo;
            this.init();
        }

        private void init() {
            this.setBorder(StarterPanel.this.DEF_BORDER);
            this.setBackground(StarterPanel.this.LIST_BG_COLOR);
            GroupLayout layout = new GroupLayout(this);
            this.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent(this.getThumbnailLabel(), -2, -1, -2).addComponent(this.getNameLabel(), -1, -1, Short.MAX_VALUE));
            layout.setVerticalGroup(layout.createSequentialGroup().addComponent(this.getThumbnailLabel(), -1, -1, Short.MAX_VALUE).addComponent(this.getNameLabel(), -2, -1, -2));
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 1 && SwingUtilities.isLeftMouseButton(e)) {
                        StarterPanel.this.maybeOpenSession(SessionPanel.this.fileInfo.getFile());
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    StarterPanel.this.drawFocus(SessionPanel.this);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    boolean inside;
                    Component c = SwingUtilities.getDeepestComponentAt(e.getComponent(), e.getX(), e.getY());
                    boolean bl = inside = c != null && SwingUtilities.isDescendingFrom(c, SessionPanel.this);
                    if (!inside) {
                        StarterPanel.this.drawFocus(SessionPanel.this, false);
                    }
                }
            };
            this.addMouseListener(mouseListener);
            this.getThumbnailLabel().addMouseListener(mouseListener);
            this.getNameLabel().addMouseListener(mouseListener);
        }

        private JLabel getThumbnailLabel() {
            if (this.thumbnailLabel == null) {
                this.thumbnailLabel = new JLabel(this.fileInfo.getIcon());
                this.thumbnailLabel.setOpaque(true);
                this.thumbnailLabel.setBackground(StarterPanel.this.LIST_BG_COLOR);
                this.thumbnailLabel.setHorizontalAlignment(0);
                this.thumbnailLabel.setHorizontalTextPosition(0);
                this.thumbnailLabel.setToolTipText(this.fileInfo.getHelp());
                this.thumbnailLabel.setBorder(BorderFactory.createLineBorder(UIManager.getColor("Separator.foreground")));
            }
            return this.thumbnailLabel;
        }

        private JLabel getNameLabel() {
            if (this.nameLabel == null) {
                this.nameLabel = new JLabel(this.fileInfo.getName());
                this.nameLabel.setForeground(StarterPanel.this.LINK_FONT_COLOR);
                LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.nameLabel});
                if (this.fileInfo.getFile() != null) {
                    this.nameLabel.setToolTipText(this.fileInfo.getFile().getPath());
                }
                this.nameLabel.setHorizontalAlignment(0);
                Dimension d = new Dimension(124, this.nameLabel.getPreferredSize().height);
                this.nameLabel.setMinimumSize(d);
                this.nameLabel.setPreferredSize(d);
                this.nameLabel.setSize(d);
            }
            return this.nameLabel;
        }
    }

    private class SessionListPanel
    extends JPanel {
        private JScrollPane scrollPane;
        private ScrollableListPanel listPanel;

        SessionListPanel(String title) {
            this.setOpaque(false);
            JLabel titleLabel = new JLabel(title);
            titleLabel.setBorder(BorderFactory.createEmptyBorder(2, 16, 2, 16));
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{titleLabel});
            this.setLayout(new BorderLayout());
            this.add((Component)titleLabel, "North");
            this.add((Component)this.getScrollPane(), "Center");
        }

        void update(List<FileInfo> files) {
            ScrollableListPanel panel = this.getListPanel();
            panel.removeAll();
            for (FileInfo fi : files) {
                SessionPanel sessionPanel = new SessionPanel(fi);
                panel.add(sessionPanel);
            }
        }

        List<SessionPanel> getAllPanels() {
            ScrollableListPanel lp = this.getListPanel();
            int total = lp.getComponentCount();
            ArrayList<SessionPanel> list = new ArrayList<SessionPanel>(total);
            for (int i = 0; i < total; ++i) {
                list.add((SessionPanel)lp.getComponent(i));
            }
            return list;
        }

        JScrollPane getScrollPane() {
            if (this.scrollPane == null) {
                this.scrollPane = new JScrollPane(this.getListPanel()){

                    @Override
                    public Dimension getPreferredSize() {
                        if (this.getViewport().getView() == null) {
                            return super.getPreferredSize();
                        }
                        int w = this.getViewport().getView().getPreferredSize().width;
                        this.setHorizontalScrollBarPolicy(32);
                        Dimension dim = new Dimension(w, super.getPreferredSize().height + this.getHorizontalScrollBar().getSize().height);
                        this.setHorizontalScrollBarPolicy(30);
                        return dim;
                    }
                };
                this.scrollPane.setVerticalScrollBarPolicy(20);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                this.scrollPane.getViewport().setBackground(this.getListPanel().getBackground());
                this.scrollPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIManager.getColor("Separator.foreground")));
                SessionPanel tmpSessionPanel = new SessionPanel(new FileInfo(new File("_tmp"), "TEMP", null));
                ScrollableListPanel tmpListPanel = new ScrollableListPanel();
                tmpListPanel.add(tmpSessionPanel);
                JScrollPane tmpScrollPane = new JScrollPane(tmpListPanel);
                int w = tmpListPanel.getPreferredSize().width + 2;
                tmpScrollPane.setHorizontalScrollBarPolicy(32);
                int vgap = ((ModifiedFlowLayout)tmpListPanel.getLayout()).getVgap() / 2;
                int h = tmpListPanel.getPreferredSize().height + tmpScrollPane.getHorizontalScrollBar().getHeight() + vgap + 2;
                this.scrollPane.setMinimumSize(new Dimension(w, h));
            }
            return this.scrollPane;
        }

        private ScrollableListPanel getListPanel() {
            if (this.listPanel == null) {
                this.listPanel = new ScrollableListPanel();
                this.listPanel.setBackground(StarterPanel.this.LIST_BG_COLOR);
            }
            return this.listPanel;
        }

        private class ScrollableListPanel
        extends JPanel
        implements Scrollable {
            public ScrollableListPanel() {
                this.setLayout(new ModifiedFlowLayout());
            }

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return this.getPreferredSize();
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return 10;
            }

            @Override
            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                return (orientation == 1 ? visibleRect.height : visibleRect.width) - 10;
            }

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }

            @Override
            public boolean getScrollableTracksViewportHeight() {
                return false;
            }
        }
    }
}

