/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.internal.view.CytoPanelImpl;
import org.cytoscape.internal.view.CytoPanelStateInternal;
import org.cytoscape.internal.view.CytoscapeMenus;
import org.cytoscape.internal.view.GridViewToggleModel;
import org.cytoscape.internal.view.NetworkViewComparisonPanel;
import org.cytoscape.internal.view.NetworkViewContainer;
import org.cytoscape.internal.view.NetworkViewFrame;
import org.cytoscape.internal.view.NetworkViewGrid;
import org.cytoscape.internal.view.NullNetworkViewPanel;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.create.CreateNetworkViewTaskFactory;
import org.cytoscape.task.destroy.DestroyNetworkViewTaskFactory;
import org.cytoscape.task.write.ExportNetworkImageTaskFactory;
import org.cytoscape.task.write.ExportNetworkViewTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.RenderingEngine;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.swing.DialogTaskManager;

public class NetworkViewMainPanel
extends JPanel {
    public static String NAME = "__NETWORK_VIEW_MAIN_PANEL__";
    private static final String VIEW_THRESHOLD = "viewThreshold";
    private static final int DEF_VIEW_THRESHOLD = 3000;
    private JPanel contentPane;
    private final CardLayout cardLayout;
    private final NetworkViewGrid networkViewGrid;
    private final GridViewToggleModel gridViewToggleModel;
    private final Map<CyNetworkView, NetworkViewContainer> allViewContainers;
    private final Map<String, NetworkViewContainer> viewCards;
    private final Map<String, NetworkViewFrame> viewFrames;
    private final Map<String, NetworkViewComparisonPanel> comparisonPanels;
    private final NullNetworkViewPanel nullViewPanel;
    private final MousePressedAWTEventListener mousePressedAWTEventListener;
    private final CytoscapeMenus cyMenus;
    private final Comparator<CyNetworkView> viewComparator;
    private final CyServiceRegistrar serviceRegistrar;

    public NetworkViewMainPanel(GridViewToggleModel gridViewToggleModel, CytoscapeMenus cyMenus, Comparator<CyNetworkView> viewComparator, CyServiceRegistrar serviceRegistrar) {
        this.gridViewToggleModel = gridViewToggleModel;
        this.cyMenus = cyMenus;
        this.viewComparator = viewComparator;
        this.serviceRegistrar = serviceRegistrar;
        this.allViewContainers = new HashMap<CyNetworkView, NetworkViewContainer>();
        this.viewCards = new LinkedHashMap<String, NetworkViewContainer>();
        this.viewFrames = new HashMap<String, NetworkViewFrame>();
        this.comparisonPanels = new HashMap<String, NetworkViewComparisonPanel>();
        this.mousePressedAWTEventListener = new MousePressedAWTEventListener();
        this.cardLayout = new CardLayout();
        this.networkViewGrid = this.createNetworkViewGrid();
        this.nullViewPanel = new NullNetworkViewPanel(gridViewToggleModel, serviceRegistrar);
        this.setName(NAME);
        this.init();
    }

    public RenderingEngine<CyNetwork> addNetworkView(CyNetworkView view, RenderingEngineFactory<CyNetwork> engineFactory, RenderingEngineFactory<CyNetwork> thumbnailFactory) {
        int numElements;
        if (this.isRendered(view)) {
            return null;
        }
        final NetworkViewContainer vc = new NetworkViewContainer(view, view.equals(this.getCurrentNetworkView()), engineFactory, thumbnailFactory, this.gridViewToggleModel, this.serviceRegistrar);
        vc.getDetachViewButton().addActionListener(evt -> this.detachNetworkView(view));
        vc.getReattachViewButton().addActionListener(evt -> this.reattachNetworkView(view));
        vc.getExportButton().addActionListener(evt -> this.showExportPopup(vc.getExportButton(), view));
        vc.getViewTitleTextField().addActionListener(evt -> {
            this.changeCurrentViewTitle(vc);
            vc.requestFocusInWindow();
        });
        vc.getViewTitleTextField().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    NetworkViewMainPanel.this.cancelViewTitleChange(vc);
                }
            }
        });
        vc.getViewTitleTextField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                NetworkViewMainPanel.this.changeCurrentViewTitle(vc);
                vc.requestFocusInWindow();
                Toolkit.getDefaultToolkit().addAWTEventListener(NetworkViewMainPanel.this.mousePressedAWTEventListener, 16L);
            }

            @Override
            public void focusGained(FocusEvent e) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(NetworkViewMainPanel.this.mousePressedAWTEventListener);
            }
        });
        this.allViewContainers.put(view, vc);
        this.viewCards.put(vc.getName(), vc);
        this.networkViewGrid.addItem(vc.getRenderingEngine(), vc.getThumbnailEngineFactory());
        this.getContentPane().add((Component)vc, vc.getName());
        if (this.isGridMode()) {
            this.updateGrid();
        }
        if ((numElements = ((CyNetwork)view.getModel()).getNodeCount() + ((CyNetwork)view.getModel()).getEdgeCount()) > this.getViewThreshold()) {
            vc.hideBirdsEyePanel();
        }
        return vc.getRenderingEngine();
    }

    private int getViewThreshold() {
        int threshold;
        Properties props = (Properties)((CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)")).getProperties();
        String vts = props.getProperty(VIEW_THRESHOLD);
        try {
            threshold = Integer.parseInt(vts);
        }
        catch (Exception e) {
            threshold = 3000;
        }
        return threshold;
    }

    public boolean isRendered(CyNetworkView view) {
        return this.allViewContainers.containsKey(view);
    }

    public void remove(CyNetworkView view) {
        NetworkViewFrame frame;
        if (view == null) {
            return;
        }
        this.allViewContainers.remove(view);
        Component[] components = this.getContentPane().getComponents();
        if (components != null) {
            for (Component c : components) {
                if (c instanceof NetworkViewContainer) {
                    NetworkViewContainer networkViewContainer = (NetworkViewContainer)c;
                    if (!networkViewContainer.getNetworkView().equals(view)) continue;
                    this.networkViewGrid.removeItems(Collections.singleton(networkViewContainer.getRenderingEngine()));
                    this.removeCard(networkViewContainer);
                    networkViewContainer.dispose();
                    continue;
                }
                if (c instanceof NetworkViewComparisonPanel) {
                    NetworkViewContainer networkViewContainer = ((NetworkViewComparisonPanel)c).getContainer(view);
                    if (networkViewContainer == null) continue;
                    this.networkViewGrid.removeItems(Collections.singleton(networkViewContainer.getRenderingEngine()));
                    ((NetworkViewComparisonPanel)c).removeView(view);
                    if (((NetworkViewComparisonPanel)c).viewCount() >= 2) continue;
                    this.endComparison((NetworkViewComparisonPanel)c);
                    continue;
                }
                if (!(c instanceof NullNetworkViewPanel)) continue;
                if (view.equals(((NullNetworkViewPanel)c).getNetworkView())) {
                    // empty if block
                }
                this.nullViewPanel.update((CyNetwork)null);
            }
        }
        if ((frame = this.viewFrames.remove(ViewUtil.createUniqueKey(view))) != null) {
            this.networkViewGrid.removeItems(Collections.singleton(frame.getRenderingEngine()));
            frame.getRootPane().getLayeredPane().removeAll();
            frame.getRootPane().getContentPane().removeAll();
            frame.dispose();
            for (ComponentListener componentListener : frame.getComponentListeners()) {
                frame.removeComponentListener(componentListener);
            }
            for (EventListener eventListener : frame.getWindowListeners()) {
                frame.removeWindowListener((WindowListener)eventListener);
            }
        }
        if (this.isGridMode()) {
            this.updateGrid();
        }
    }

    public boolean hasViews(CyNetwork network) {
        for (CyNetworkView view : this.allViewContainers.keySet()) {
            if (!((CyNetwork)view.getModel()).equals(network)) continue;
            return true;
        }
        return false;
    }

    public void setSelectedNetworkViews(Collection<CyNetworkView> networkViews) {
        this.networkViewGrid.setSelectedNetworkViews(networkViews);
    }

    public List<CyNetworkView> getSelectedNetworkViews() {
        return this.networkViewGrid.getSelectedNetworkViews();
    }

    public CyNetworkView getCurrentNetworkView() {
        return this.networkViewGrid.getCurrentNetworkView();
    }

    public void setCurrentNetworkView(CyNetworkView view) {
        boolean currentViewChanged = this.networkViewGrid.setCurrentNetworkView(view);
        if (currentViewChanged && view != null) {
            Window window;
            NetworkViewContainer vc;
            if (this.isGridMode()) {
                if (this.isGridVisible()) {
                    this.updateGrid();
                } else {
                    this.showGrid(true);
                }
            } else {
                this.showViewContainer(ViewUtil.createUniqueKey(view));
            }
            if (this.isGridVisible()) {
                this.networkViewGrid.scrollToCurrentItem();
            }
            if ((vc = this.getNetworkViewContainer(view)) != null && (window = SwingUtilities.getWindowAncestor(vc)) != null && !window.isActive()) {
                window.toFront();
            }
        }
    }

    public void showNullView(CyNetwork network) {
        if (this.isGridMode()) {
            if (this.isGridVisible()) {
                this.updateGrid();
            } else {
                this.showGrid(true);
            }
        } else {
            this.showNullViewContainer(network);
        }
    }

    public void showGrid() {
        this.showGrid(false);
    }

    public void showGrid(boolean scrollToCurrentItem) {
        if (!this.isGridMode()) {
            this.gridViewToggleModel.setMode(GridViewToggleModel.Mode.GRID);
            return;
        }
        if (!this.isGridVisible()) {
            this.cardLayout.show(this.getContentPane(), this.networkViewGrid.getName());
            this.updateGrid();
        }
        if (scrollToCurrentItem) {
            this.networkViewGrid.scrollToCurrentItem();
        }
    }

    public void updateGrid() {
        this.networkViewGrid.update(this.networkViewGrid.getThumbnailSlider().getValue());
    }

    public void detachNetworkViews(Collection<CyNetworkView> views) {
        CyNetworkView currentView = this.getCurrentNetworkView();
        for (CyNetworkView v : views) {
            this.detachNetworkView(v);
        }
        NetworkViewFrame frame = this.getNetworkViewFrame(currentView);
        if (frame != null) {
            frame.toFront();
        }
    }

    public NetworkViewFrame detachNetworkView(CyNetworkView view) {
        if (view == null) {
            return null;
        }
        GraphicsConfiguration gc = ((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame().getGraphicsConfiguration();
        return this.detachNetworkView(view, gc);
    }

    public NetworkViewFrame detachNetworkView(final CyNetworkView view, GraphicsConfiguration gc) {
        boolean resizable;
        if (view == null) {
            return null;
        }
        NetworkViewContainer vc = this.getNetworkViewCard(view);
        if (vc == null) {
            return null;
        }
        this.getNetworkViewGrid().setDetached(vc.getNetworkView(), true);
        this.removeCard(vc);
        if (!this.isGridMode()) {
            this.showNullViewContainer(view);
        }
        if (this.viewFrames.get(vc.getName()) != null) {
            return this.viewFrames.get(vc.getName());
        }
        Double width = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH);
        Double height = (Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT);
        if (width == null || width <= 0.0) {
            view.setVisualProperty(BasicVisualLexicon.NETWORK_WIDTH, (Object)600.0);
        }
        if (height == null || height <= 0.0) {
            view.setVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT, (Object)500.0);
        }
        final NetworkViewFrame frame = new NetworkViewFrame(vc, gc, this.cyMenus.createViewFrameToolBar(), this.serviceRegistrar);
        vc.setDetached(true);
        vc.setComparing(false);
        this.viewFrames.put(vc.getName(), frame);
        if (!ViewUtil.isScreenMenuBar()) {
            frame.setJMenuBar(this.cyMenus.createDummyMenuBar());
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ((DialogTaskManager)NetworkViewMainPanel.this.serviceRegistrar.getService(DialogTaskManager.class)).setExecutionContext((Object)frame);
                JMenuBar menuBar = NetworkViewMainPanel.this.cyMenus.getJMenuBar();
                Window window = SwingUtilities.getWindowAncestor(menuBar);
                if (!frame.equals(window)) {
                    if (window instanceof JFrame && !ViewUtil.isScreenMenuBar()) {
                        JMenuBar dummyMenuBar = NetworkViewMainPanel.this.cyMenus.createDummyMenuBar();
                        ((JFrame)window).setJMenuBar(dummyMenuBar);
                        dummyMenuBar.updateUI();
                        window.repaint();
                    }
                    frame.setJMenuBar(menuBar);
                }
                if (ViewUtil.isScreenMenuBar() && menuBar.equals(frame.getJMenuBar())) {
                    NetworkViewMainPanel.this.cyMenus.setMenuBarVisible(true);
                }
                menuBar.updateUI();
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                if (ViewUtil.isScreenMenuBar() && NetworkViewMainPanel.this.cyMenus.getJMenuBar().equals(frame.getJMenuBar())) {
                    NetworkViewMainPanel.this.cyMenus.setMenuBarVisible(false);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                NetworkViewMainPanel.this.reattachNetworkView(view);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowActivated(WindowEvent e) {
                        NetworkViewMainPanel.this.setSelectedNetworkViews(Collections.singletonList(frame.getNetworkView()));
                        NetworkViewMainPanel.this.setCurrentNetworkView(frame.getNetworkView());
                    }
                });
            }
        });
        int w = ((Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH)).intValue();
        int h = ((Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT)).intValue();
        boolean bl = resizable = !view.isValueLocked(BasicVisualLexicon.NETWORK_WIDTH) && !view.isValueLocked(BasicVisualLexicon.NETWORK_HEIGHT);
        if (w > 0 && h > 0) {
            frame.getNetworkViewContainer().getVisualizationContainer().setPreferredSize(new Dimension(w, h));
        }
        frame.pack();
        frame.setResizable(resizable);
        frame.setVisible(true);
        return frame;
    }

    public void reattachNetworkView(CyNetworkView view) {
        NetworkViewFrame frame = this.getNetworkViewFrame(view);
        if (frame != null) {
            NetworkViewContainer vc = frame.getNetworkViewContainer();
            frame.setJMenuBar(null);
            frame.dispose();
            this.viewFrames.remove(vc.getName());
            vc.setDetached(false);
            vc.setComparing(false);
            this.getContentPane().add((Component)vc, vc.getName());
            this.viewCards.put(vc.getName(), vc);
            this.getNetworkViewGrid().setDetached(view, false);
            if (!this.isGridMode() && view.equals(this.getCurrentNetworkView())) {
                this.showViewContainer(vc.getName());
            }
        }
    }

    public void updateThumbnailPanel(CyNetworkView view, boolean redraw) {
        NetworkViewGrid.ThumbnailPanel tp;
        if (this.isGridVisible() && (tp = this.networkViewGrid.getItem(view)) != null) {
            tp.update(redraw);
        }
    }

    public void update(CyNetworkView view, boolean updateSelectionInfo, boolean updateHiddenInfo) {
        NetworkViewFrame frame = this.getNetworkViewFrame(view);
        if (frame != null) {
            boolean resizable;
            frame.setTitle(ViewUtil.getTitle(view));
            int w = ((Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_WIDTH)).intValue();
            int h = ((Double)view.getVisualProperty(BasicVisualLexicon.NETWORK_HEIGHT)).intValue();
            boolean bl = resizable = !view.isValueLocked(BasicVisualLexicon.NETWORK_WIDTH) && !view.isValueLocked(BasicVisualLexicon.NETWORK_HEIGHT);
            if (w > 0 && h > 0 && w != frame.getContentPane().getWidth() && h != frame.getContentPane().getHeight()) {
                frame.getContentPane().setPreferredSize(new Dimension(w, h));
                frame.pack();
            }
            frame.setResizable(resizable);
            frame.update();
            frame.invalidate();
        } else if (!this.isGridVisible()) {
            NetworkViewComparisonPanel cp;
            NetworkViewContainer vc = this.getNetworkViewCard(view);
            if (vc != null && vc.equals(this.getCurrentViewContainer())) {
                vc.update(updateSelectionInfo, updateHiddenInfo);
            }
            if ((cp = this.getComparisonPanel(view)) != null) {
                cp.update();
            }
        }
        this.updateThumbnailPanel(view, false);
    }

    public void updateSelectionInfo(CyNetworkView view) {
        NetworkViewContainer vc = this.getNetworkViewContainer(view);
        if (vc != null) {
            vc.updateSelectionInfo();
        }
    }

    public boolean isEmpty() {
        return this.allViewContainers.isEmpty();
    }

    public NetworkViewGrid getNetworkViewGrid() {
        return this.networkViewGrid;
    }

    public Set<NetworkViewFrame> getAllNetworkViewFrames() {
        return new HashSet<NetworkViewFrame>(this.viewFrames.values());
    }

    public Set<NetworkViewContainer> getAllNetworkViewContainers() {
        return new HashSet<NetworkViewContainer>(this.allViewContainers.values());
    }

    public void showNullViewContainer(CyNetwork net) {
        this.nullViewPanel.update((CyNetwork)(net instanceof CySubNetwork ? (CySubNetwork)net : null));
        this.showNullViewContainer();
    }

    public void showNullViewContainer(CyNetworkView view) {
        this.nullViewPanel.update(view);
        this.showNullViewContainer();
    }

    public NetworkViewContainer showViewContainer(CyNetworkView view) {
        return view != null ? this.showViewContainer(ViewUtil.createUniqueKey(view)) : null;
    }

    public void dispose() {
        this.networkViewGrid.dispose();
        this.removeAll();
    }

    private NetworkViewContainer showViewContainer(String key) {
        NetworkViewContainer viewContainer = null;
        if (key != null) {
            viewContainer = this.viewCards.get(key);
            if (this.isGridMode()) {
                this.gridViewToggleModel.setMode(GridViewToggleModel.Mode.VIEW);
            }
            if (viewContainer != null) {
                this.cardLayout.show(this.getContentPane(), key);
                viewContainer.update(true, true);
            } else {
                Component foundCompPanel = null;
                block0: for (NetworkViewComparisonPanel cp : this.comparisonPanels.values()) {
                    if (key.equals(cp.getName())) {
                        foundCompPanel = cp;
                        continue;
                    }
                    for (NetworkViewContainer vc : cp.getAllContainers()) {
                        if (!key.equals(vc.getName())) continue;
                        foundCompPanel = cp;
                        continue block0;
                    }
                }
                if (foundCompPanel != null) {
                    this.cardLayout.show(this.getContentPane(), foundCompPanel.getName());
                    ((NetworkViewComparisonPanel)foundCompPanel).update();
                    viewContainer = ((NetworkViewComparisonPanel)foundCompPanel).getCurrentContainer();
                } else {
                    NetworkViewFrame frame = this.getNetworkViewFrame(key);
                    if (frame != null && !this.isGridMode()) {
                        this.showNullViewContainer(frame.getNetworkView());
                    }
                }
            }
        } else {
            this.showGrid();
        }
        return viewContainer;
    }

    private void showNullViewContainer() {
        this.cardLayout.show(this.getContentPane(), this.nullViewPanel.getName());
    }

    protected void showViewFrame(NetworkViewFrame frame) {
        frame.setVisible(true);
        frame.toFront();
    }

    protected void showComparisonPanel(Set<CyNetworkView> views) {
        CyNetworkView currentView = this.getCurrentNetworkView();
        String key = NetworkViewComparisonPanel.createUniqueKey(views);
        NetworkViewComparisonPanel cp = this.comparisonPanels.get(key);
        if (cp == null) {
            for (CyNetworkView v : views) {
                cp = this.getComparisonPanel(v);
                if (cp == null) continue;
                this.endComparison(cp);
            }
            LinkedHashSet<NetworkViewContainer> containersToCompare = new LinkedHashSet<NetworkViewContainer>();
            for (CyNetworkView v : views) {
                NetworkViewContainer vc;
                NetworkViewFrame frame = this.getNetworkViewFrame(v);
                if (frame != null) {
                    this.reattachNetworkView(v);
                }
                if ((vc = this.getNetworkViewCard(v)) == null) continue;
                this.removeCard(vc);
                containersToCompare.add(vc);
            }
            cp = new NetworkViewComparisonPanel(this.gridViewToggleModel, containersToCompare, currentView, this.serviceRegistrar);
            cp.getDetachComparedViewsButton().addActionListener(evt -> {
                Component currentCard = this.getCurrentCard();
                if (currentCard instanceof NetworkViewComparisonPanel) {
                    NetworkViewComparisonPanel ncp = (NetworkViewComparisonPanel)currentCard;
                    Set<CyNetworkView> viewSet = ncp.getAllNetworkViews();
                    this.endComparison(ncp);
                    this.detachNetworkViews(viewSet);
                }
            });
            cp.addPropertyChangeListener("currentNetworkView", evt -> {
                CyNetworkView newCurrentView = (CyNetworkView)evt.getNewValue();
                this.setCurrentNetworkView(newCurrentView);
            });
            this.getContentPane().add((Component)cp, cp.getName());
            this.comparisonPanels.put(cp.getName(), cp);
        }
        if (cp != null) {
            this.gridViewToggleModel.setMode(GridViewToggleModel.Mode.VIEW);
            this.showViewContainer(cp.getName());
        }
    }

    protected void endComparison(NetworkViewComparisonPanel cp) {
        if (cp != null) {
            this.removeCard(cp);
            cp.dispose();
            for (NetworkViewContainer vc : cp.getAllContainers()) {
                this.getContentPane().add((Component)vc, vc.getName());
                this.viewCards.put(vc.getName(), vc);
            }
        }
    }

    private NetworkViewComparisonPanel getComparisonPanel(CyNetworkView view) {
        for (NetworkViewComparisonPanel cp : this.comparisonPanels.values()) {
            if (!cp.contains(view)) continue;
            return cp;
        }
        return null;
    }

    private void removeCard(JComponent comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof NetworkViewContainer) {
            this.viewCards.remove(((NetworkViewContainer)comp).getName());
        } else if (comp instanceof NetworkViewComparisonPanel) {
            this.comparisonPanels.remove(((NetworkViewComparisonPanel)comp).getName());
        }
        this.cardLayout.removeLayoutComponent(comp);
        this.getContentPane().remove(comp);
    }

    protected boolean isGridMode() {
        return this.gridViewToggleModel.getMode() == GridViewToggleModel.Mode.GRID;
    }

    protected boolean isGridVisible() {
        return this.getCurrentCard() == this.networkViewGrid;
    }

    protected NetworkViewContainer getCurrentViewContainer() {
        Component c = this.getCurrentCard();
        return c instanceof NetworkViewContainer ? (NetworkViewContainer)c : null;
    }

    protected Component getCurrentCard() {
        Component current = null;
        for (Component comp : this.getContentPane().getComponents()) {
            if (!comp.isVisible()) continue;
            current = comp;
        }
        return current;
    }

    private NetworkViewGrid createNetworkViewGrid() {
        NetworkViewGrid nvg = new NetworkViewGrid(this.gridViewToggleModel, this.viewComparator, this.serviceRegistrar);
        nvg.getDetachSelectedViewsButton().addActionListener(evt -> {
            List<NetworkViewGrid.ThumbnailPanel> selectedItems = this.networkViewGrid.getSelectedItems();
            if (selectedItems != null) {
                CyNetworkView currentView = this.getCurrentNetworkView();
                for (NetworkViewGrid.ThumbnailPanel tp : selectedItems) {
                    if (this.getNetworkViewCard(tp.getNetworkView()) == null) continue;
                    this.detachNetworkView(tp.getNetworkView());
                }
                NetworkViewFrame frame = this.getNetworkViewFrame(currentView);
                if (frame != null) {
                    frame.toFront();
                }
            }
        });
        nvg.getReattachAllViewsButton().addActionListener(evt -> {
            ArrayList<NetworkViewFrame> allFrames = new ArrayList<NetworkViewFrame>(this.viewFrames.values());
            for (NetworkViewFrame f : allFrames) {
                this.reattachNetworkView(f.getNetworkView());
            }
        });
        nvg.getDestroySelectedViewsButton().addActionListener(evt -> {
            List<CyNetworkView> selectedViews = this.getSelectedNetworkViews();
            if (selectedViews != null && !selectedViews.isEmpty()) {
                DialogTaskManager taskMgr = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
                DestroyNetworkViewTaskFactory taskFactory = (DestroyNetworkViewTaskFactory)this.serviceRegistrar.getService(DestroyNetworkViewTaskFactory.class);
                taskMgr.execute(taskFactory.createTaskIterator(selectedViews));
            }
        });
        return nvg;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getContentPane(), "Center");
        this.nullViewPanel.getCreateViewButton().addActionListener(evt -> {
            if (this.nullViewPanel.getNetwork() instanceof CySubNetwork) {
                CreateNetworkViewTaskFactory factory = (CreateNetworkViewTaskFactory)this.serviceRegistrar.getService(CreateNetworkViewTaskFactory.class);
                DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
                taskManager.execute(factory.createTaskIterator(Collections.singleton(this.nullViewPanel.getNetwork())));
            }
        });
        this.nullViewPanel.getInfoIconLabel().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                NetworkViewFrame frame;
                if (!e.isPopupTrigger() && NetworkViewMainPanel.this.nullViewPanel.getNetworkView() != null && (frame = NetworkViewMainPanel.this.getNetworkViewFrame(NetworkViewMainPanel.this.nullViewPanel.getNetworkView())) != null) {
                    NetworkViewMainPanel.this.showViewFrame(frame);
                }
            }
        });
        this.nullViewPanel.getReattachViewButton().addActionListener(evt -> {
            if (this.nullViewPanel.getNetworkView() != null) {
                this.reattachNetworkView(this.nullViewPanel.getNetworkView());
            }
        });
        this.networkViewGrid.addPropertyChangeListener("selectedNetworkViews", evt -> this.firePropertyChange("selectedNetworkViews", evt.getOldValue(), evt.getNewValue()));
        this.networkViewGrid.addPropertyChangeListener("currentNetworkView", evt -> {
            CyNetworkView curView = (CyNetworkView)evt.getNewValue();
            for (NetworkViewContainer vc : this.getAllNetworkViewContainers()) {
                vc.setCurrent(vc.getNetworkView().equals(curView));
            }
        });
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mousePressedAWTEventListener, 16L);
        this.updateGrid();
    }

    private JPanel getContentPane() {
        if (this.contentPane == null) {
            this.contentPane = new JPanel();
            this.contentPane.setLayout(this.cardLayout);
            this.contentPane.add((Component)this.nullViewPanel, this.nullViewPanel.getName());
            this.contentPane.add((Component)this.networkViewGrid, this.networkViewGrid.getName());
        }
        return this.contentPane;
    }

    protected NetworkViewContainer getNetworkViewContainer(CyNetworkView view) {
        return view != null ? this.allViewContainers.get(view) : null;
    }

    protected NetworkViewContainer getNetworkViewCard(CyNetworkView view) {
        return view != null ? this.viewCards.get(ViewUtil.createUniqueKey(view)) : null;
    }

    protected NetworkViewFrame getNetworkViewFrame(CyNetworkView view) {
        return view != null ? this.getNetworkViewFrame(ViewUtil.createUniqueKey(view)) : null;
    }

    protected NetworkViewFrame getNetworkViewFrame(String key) {
        return key != null ? this.viewFrames.get(key) : null;
    }

    private void changeCurrentViewTitle(NetworkViewContainer vc) {
        String text = vc.getViewTitleTextField().getText();
        if (text != null && !(text = text.trim()).isEmpty()) {
            vc.getViewTitleLabel().setText(text);
            CyNetworkView view = vc.getNetworkView();
            view.setVisualProperty(BasicVisualLexicon.NETWORK_TITLE, (Object)text);
            this.updateThumbnailPanel(view, false);
        }
        vc.getViewTitleTextField().setText(null);
        vc.getViewTitleTextField().setVisible(false);
        vc.getViewTitleLabel().setVisible(true);
        vc.getToolBar().updateUI();
    }

    private void cancelViewTitleChange(NetworkViewContainer vc) {
        vc.getViewTitleTextField().setText(null);
        vc.getViewTitleTextField().setVisible(false);
        vc.getViewTitleLabel().setVisible(true);
    }

    private void showExportPopup(JComponent source, CyNetworkView view) {
        DialogTaskManager taskMgr = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        JPopupMenu popupMenu = new JPopupMenu();
        JMenuItem mi = new JMenuItem("Export as Network...");
        mi.addActionListener(evt -> {
            ExportNetworkViewTaskFactory factory = (ExportNetworkViewTaskFactory)this.serviceRegistrar.getService(ExportNetworkViewTaskFactory.class);
            taskMgr.execute(factory.createTaskIterator(view));
        });
        popupMenu.add(mi);
        mi = new JMenuItem("Export as Image...");
        mi.addActionListener(evt -> {
            ExportNetworkImageTaskFactory factory = (ExportNetworkImageTaskFactory)this.serviceRegistrar.getService(ExportNetworkImageTaskFactory.class);
            taskMgr.execute(factory.createTaskIterator(view));
        });
        popupMenu.add(mi);
        popupMenu.show(source, 0, source.getHeight());
    }

    private class MousePressedAWTEventListener
    implements AWTEventListener {
        private MousePressedAWTEventListener() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void eventDispatched(AWTEvent event) {
            if (event.getID() == 501 && event instanceof MouseEvent) {
                KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                Window window = keyboardFocusManager.getActiveWindow();
                if (!(window instanceof NetworkViewFrame) && !(window instanceof CySwingApplication)) {
                    return;
                }
                MouseEvent me = (MouseEvent)event;
                if (window instanceof CySwingApplication) {
                    void var7_10;
                    CytoPanelName[] cytoPanelNameArray = CytoPanelName.values();
                    int n = cytoPanelNameArray.length;
                    boolean bl = false;
                    while (var7_10 < n) {
                        CytoPanelName cpName = cytoPanelNameArray[var7_10];
                        CytoPanel cp = ((CySwingApplication)window).getCytoPanel(cpName);
                        if (cp instanceof CytoPanelImpl && cp.getThisComponent() != null && ((CytoPanelImpl)cp).getStateInternal() == CytoPanelStateInternal.UNDOCK) {
                            Point pt = new Point(SwingUtilities.convertPoint(me.getComponent(), me.getPoint(), cp.getThisComponent()));
                            if (cp.getThisComponent().contains(pt)) {
                                return;
                            }
                        }
                        ++var7_10;
                    }
                }
                HashSet<Container> targets = new HashSet<Container>();
                if (window instanceof NetworkViewFrame) {
                    targets.add(((NetworkViewFrame)window).getContainerRootPane().getContentPane());
                } else {
                    Component currentCard = NetworkViewMainPanel.this.getCurrentCard();
                    if (currentCard instanceof NetworkViewContainer) {
                        NetworkViewContainer networkViewContainer = (NetworkViewContainer)currentCard;
                        targets.add(networkViewContainer.getContentPane());
                    } else if (currentCard instanceof NetworkViewComparisonPanel) {
                        NetworkViewComparisonPanel networkViewComparisonPanel = (NetworkViewComparisonPanel)currentCard;
                        NetworkViewContainer currentContainer = networkViewComparisonPanel.getCurrentContainer();
                        for (NetworkViewContainer vc : networkViewComparisonPanel.getAllContainers()) {
                            if (vc == currentContainer) continue;
                            targets.add(vc.getContentPane());
                        }
                    }
                }
                for (Component component : targets) {
                    me = SwingUtilities.convertMouseEvent(me.getComponent(), me, component);
                    if (!component.getBounds().contains(me.getPoint())) continue;
                    component.requestFocusInWindow();
                }
            }
        }
    }
}

