/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.cytoscape.app.event.AppsFinishedStartingEvent;
import org.cytoscape.app.event.AppsFinishedStartingListener;
import org.cytoscape.application.swing.search.AbstractNetworkSearchTaskFactory;
import org.cytoscape.application.swing.search.NetworkSearchTaskFactory;
import org.cytoscape.internal.view.NetworkSearchBar;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;
import org.cytoscape.work.swing.PanelTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkSearchMediator
implements AppsFinishedStartingListener {
    private final Map<String, NetworkSearchTaskFactory> taskFactories = new HashMap<String, NetworkSearchTaskFactory>();
    private final Map<NetworkSearchTaskFactory, JComponent> optionsComponents = new HashMap<NetworkSearchTaskFactory, JComponent>();
    private final Map<NetworkSearchTaskFactory, JComponent> queryComponents = new HashMap<NetworkSearchTaskFactory, JComponent>();
    private final NetworkSearchBar networkSearchBar;
    private final CyServiceRegistrar serviceRegistrar;
    private boolean appsFinishedStarting;
    private final Object lock = new Object();
    private static Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public NetworkSearchMediator(NetworkSearchBar networkSearchBar, CyServiceRegistrar serviceRegistrar) {
        this.networkSearchBar = networkSearchBar;
        this.serviceRegistrar = serviceRegistrar;
        this.addListeners();
    }

    public NetworkSearchBar getNetworkSearchBar() {
        return this.networkSearchBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNetworkSearchTaskFactory(NetworkSearchTaskFactory factory, Map<?, ?> properties) {
        if (factory.getId() != null && !factory.getId().trim().isEmpty()) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    if (factory != null) {
                        JComponent oc;
                        JComponent qc = factory.getQueryComponent();
                        if (qc != null) {
                            this.queryComponents.put(factory, qc);
                            qc.addPropertyChangeListener("query", new QueryChangeListener(factory));
                            qc.addPropertyChangeListener("searchRequested", new SearchRequestedListener(factory));
                        }
                        if ((oc = factory.getOptionsComponent()) == null) {
                            PanelTaskManager taskManager = (PanelTaskManager)this.serviceRegistrar.getService(PanelTaskManager.class);
                            oc = (JComponent)taskManager.getConfiguration((TaskFactory)factory, (Object)factory);
                            if (oc != null) {
                                ViewUtil.recursiveDo(oc, c -> ViewUtil.makeSmall(c));
                                ViewUtil.recursiveDo(oc, c -> {
                                    if (c instanceof JPanel) {
                                        ((JPanel)c).setBackground(UIManager.getColor("Table.background"));
                                    }
                                });
                            }
                        } else {
                            oc.addPropertyChangeListener("query", new QueryChangeListener(factory));
                        }
                        if (oc != null) {
                            this.optionsComponents.put(factory, oc);
                        }
                    }
                    this.taskFactories.put(factory.getId(), factory);
                }
                boolean appsFinishedStarting = this.appsFinishedStarting;
                ViewUtil.invokeOnEDT(() -> {
                    this.updateSearchPanel();
                    if (factory != null && appsFinishedStarting) {
                        this.networkSearchBar.setSelectedProvider(factory);
                    }
                });
            }
            catch (Exception e) {
                logger.error("Cannot install Network Search Provider: " + factory, (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetworkSearchTaskFactory(NetworkSearchTaskFactory factory, Map<?, ?> properties) {
        boolean removed = false;
        Object object = this.lock;
        synchronized (object) {
            this.queryComponents.remove(factory);
            this.optionsComponents.remove(factory);
            if (factory.getId() != null) {
                removed = this.taskFactories.remove(factory.getId(), factory);
            }
        }
        if (removed) {
            this.updateSearchPanel();
        }
    }

    public void handleEvent(AppsFinishedStartingEvent evt) {
        this.appsFinishedStarting = true;
    }

    private void addListeners() {
        this.networkSearchBar.addPropertyChangeListener("selectedProvider", evt -> {
            NetworkSearchTaskFactory tf = (NetworkSearchTaskFactory)evt.getNewValue();
            if (tf != null) {
                this.updateSelectedProvider(tf);
            }
            this.updateSelectedSearchComponent(tf);
            this.networkSearchBar.updateProvidersButton();
            this.networkSearchBar.updateSearchEnabled();
        });
        this.networkSearchBar.getSearchTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                NetworkSearchMediator.this.updateSelectedProvider(NetworkSearchMediator.this.networkSearchBar.getSelectedProvider());
                NetworkSearchMediator.this.networkSearchBar.updateSearchButton();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                NetworkSearchMediator.this.updateSelectedProvider(NetworkSearchMediator.this.networkSearchBar.getSelectedProvider());
                NetworkSearchMediator.this.networkSearchBar.updateSearchButton();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.networkSearchBar.getSearchTextField().addActionListener(evt -> this.runSearch());
        this.networkSearchBar.getOptionsButton().addActionListener(evt -> {
            if (this.networkSearchBar.getSelectedProvider() != null && this.networkSearchBar.getOptionsButton().isSelected()) {
                this.networkSearchBar.showOptionsDialog(this.optionsComponents.get(this.networkSearchBar.getSelectedProvider()));
            }
        });
        this.networkSearchBar.getSearchButton().addActionListener(evt -> this.runSearch());
    }

    private void updateSelectedProvider(NetworkSearchTaskFactory factory) {
        JComponent queryComp = this.queryComponents.get(factory);
        if (factory instanceof AbstractNetworkSearchTaskFactory && queryComp == null) {
            ((AbstractNetworkSearchTaskFactory)factory).setQuery(this.networkSearchBar.getSearchTextField().getText().trim());
        }
    }

    private void updateSelectedSearchComponent(NetworkSearchTaskFactory factory) {
        ViewUtil.invokeOnEDT(() -> {
            JComponent queryComp = this.queryComponents.get(factory);
            JComponent optionsComp = this.optionsComponents.get(factory);
            this.networkSearchBar.updateSelectedSearchComponent(queryComp);
            this.networkSearchBar.getOptionsButton().setVisible(optionsComp != null);
            this.networkSearchBar.updateSearchButton();
        });
    }

    private void updateSearchPanel() {
        ViewUtil.invokeOnEDT(() -> this.networkSearchBar.update(new HashSet<NetworkSearchTaskFactory>(this.taskFactories.values())));
    }

    private void runSearch() {
        NetworkSearchTaskFactory tf = this.networkSearchBar.getSelectedProvider();
        if (tf != null && tf.isReady()) {
            DialogTaskManager taskManager = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
            TaskObserver taskObserver = tf.getTaskObserver();
            if (taskObserver != null) {
                taskManager.execute(tf.createTaskIterator(), taskObserver);
            } else {
                taskManager.execute(tf.createTaskIterator());
            }
        }
    }

    private class SearchRequestedListener
    implements PropertyChangeListener {
        private NetworkSearchTaskFactory factory;

        public SearchRequestedListener(NetworkSearchTaskFactory factory) {
            this.factory = factory;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.factory.equals(NetworkSearchMediator.this.networkSearchBar.getSelectedProvider()) && this.factory.isReady()) {
                NetworkSearchMediator.this.runSearch();
            }
        }
    }

    private class QueryChangeListener
    implements PropertyChangeListener {
        private NetworkSearchTaskFactory factory;

        public QueryChangeListener(NetworkSearchTaskFactory factory) {
            this.factory = factory;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (this.factory.equals(NetworkSearchMediator.this.networkSearchBar.getSelectedProvider())) {
                ViewUtil.invokeOnEDT(() -> NetworkSearchMediator.this.networkSearchBar.updateSearchButton());
            }
        }
    }
}

