/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuListener;
import org.cytoscape.application.CyApplicationConfiguration;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CyAction;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.GravityTracker;
import org.cytoscape.util.swing.JMenuTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CytoscapeMenuBar
extends JMenuBar {
    public static final String DEFAULT_MENU_SPECIFIER = "Tools";
    private static final String TABSTR = "\t";
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private final Map<Action, JMenuItem> actionMenuItemMap;
    private final Map<String, String> actionOverrideMap;
    private final JMenuTracker menuTracker;
    private HashSet<String> stopList = new HashSet();
    private static boolean produceActionTable;
    private final CyServiceRegistrar registrar;

    public CytoscapeMenuBar(CyServiceRegistrar reg) {
        this.registrar = reg;
        this.actionMenuItemMap = new HashMap<Action, JMenuItem>();
        this.actionOverrideMap = new HashMap<String, String>();
        this.menuTracker = new JMenuTracker((JMenuBar)this);
        this.setMinimumSize(this.getMenu("File").getPreferredSize());
        this.readStopList();
        this.readMenuCustomizer();
    }

    public boolean addAction(CyAction action) {
        boolean showGravity;
        KeyStroke accelerator;
        AbstractCyAction configgedAction;
        if (null == action.getName()) {
            return false;
        }
        if (produceActionTable) {
            this.dumpActionToTable(action);
        }
        if ((configgedAction = this.configgedAction(action)) == null || !configgedAction.isInMenuBar()) {
            return false;
        }
        boolean insertSepBefore = configgedAction.insertSeparatorBefore();
        boolean insertSepAfter = configgedAction.insertSeparatorAfter();
        if (this.actionMenuItemMap.containsKey(configgedAction)) {
            return false;
        }
        String menuName = configgedAction.getPreferredMenu();
        if (menuName == null || menuName.isEmpty()) {
            return false;
        }
        GravityTracker gravityTracker = this.menuTracker.getGravityTracker(menuName);
        JMenuItem mi = this.createMenuItem((CyAction)configgedAction);
        String item = configgedAction.getName();
        if (this.stopList.contains(item)) {
            mi.setVisible(false);
        }
        if ((accelerator = configgedAction.getAcceleratorKeyStroke()) != null) {
            mi.setAccelerator(accelerator);
        }
        ((JMenu)gravityTracker.getMenu()).addMenuListener((MenuListener)configgedAction);
        if (insertSepBefore) {
            gravityTracker.addMenuSeparator((double)configgedAction.getMenuGravity() - 1.0E-4);
        }
        gravityTracker.addMenuItem(mi, (double)configgedAction.getMenuGravity());
        if (insertSepAfter) {
            gravityTracker.addMenuSeparator((double)configgedAction.getMenuGravity() + 1.0E-4);
        }
        if (showGravity = false) {
            Object debugName = configgedAction.getName();
            debugName = "[" + configgedAction.getMenuGravity() + "] " + (String)debugName;
            configgedAction.setName((String)debugName);
        }
        logger.debug("Inserted action for menu: " + menuName + " with gravity: " + configgedAction.getMenuGravity());
        this.actionMenuItemMap.put((Action)configgedAction, mi);
        this.revalidate();
        this.repaint();
        return true;
    }

    private void dumpActionToTable(CyAction action) {
        Object clasname = "" + action.getClass();
        clasname = ((String)clasname).substring(1 + ((String)clasname).lastIndexOf(46));
        System.out.println(action.getName() + TABSTR + (Serializable)(action.getAcceleratorKeyStroke() == null ? "" : action.getAcceleratorKeyStroke()) + TABSTR + (action.isInMenuBar() ? "T" : "F") + TABSTR + (action.getPreferredMenu() == null ? "" : action.getPreferredMenu()) + TABSTR + action.getMenuGravity() + TABSTR + (action.isInToolBar() ? "T" : "F") + TABSTR + action.getToolbarGravity() + TABSTR + (action.isEnabled() ? "T" : "F") + TABSTR + (String)clasname + TABSTR);
    }

    private AbstractCyAction configgedAction(CyAction action) {
        String mappedAction = this.actionOverrideMap.get(action.getName());
        if (mappedAction != null) {
            String[] tokens = mappedAction.split(TABSTR);
            String accelerator = tokens[1];
            if (tokens.length == 9) {
                boolean enabled = "T".equals(tokens[7]);
                action.setEnabled(enabled);
            }
            try {
                AbstractCyAction cast = (AbstractCyAction)action;
                cast.setAcceleratorKeyStroke(KeyStroke.getKeyStroke(accelerator));
            }
            catch (ClassCastException e) {
                System.err.println("Action isn't an AbstractCyAction");
            }
        }
        return (AbstractCyAction)action;
    }

    public void showAll() {
        for (JMenuItem item : this.actionMenuItemMap.values()) {
            item.setVisible(true);
        }
    }

    public void addSeparator(String menuName, double gravity) {
        if (menuName == null || menuName.isEmpty()) {
            menuName = DEFAULT_MENU_SPECIFIER;
        }
        GravityTracker gravityTracker = this.menuTracker.getGravityTracker(menuName);
        gravityTracker.addMenuSeparator(gravity);
    }

    public boolean removeAction(CyAction action) {
        JMenuItem menuItem = this.actionMenuItemMap.remove(action);
        if (menuItem == null) {
            return false;
        }
        String menuName = null;
        if (!action.isInMenuBar()) {
            return false;
        }
        menuName = action.getPreferredMenu();
        if (menuName == null) {
            menuName = DEFAULT_MENU_SPECIFIER;
        }
        GravityTracker gravityTracker = this.menuTracker.getGravityTracker(menuName);
        gravityTracker.removeComponent((Component)menuItem);
        ((JMenu)gravityTracker.getMenu()).removeMenuListener((MenuListener)action);
        return true;
    }

    public JMenu addMenu(String menuName, double gravity) {
        menuName = (String)menuName + "[" + gravity + "]";
        GravityTracker gravityTracker = this.menuTracker.getGravityTracker((String)menuName);
        return (JMenu)gravityTracker.getMenu();
    }

    public JMenu getMenu(String menuName) {
        if (menuName == null) {
            menuName = DEFAULT_MENU_SPECIFIER;
        }
        GravityTracker gravityTracker = this.menuTracker.getGravityTracker(menuName);
        this.revalidate();
        this.repaint();
        return (JMenu)gravityTracker.getMenu();
    }

    public JMenuTracker getMenuTracker() {
        return this.menuTracker;
    }

    private JMenuItem createMenuItem(CyAction action) {
        JMenuItem ret = action.useCheckBoxMenuItem() ? new JCheckBoxMenuItem((Action)action) : new JMenuItem((Action)action);
        return ret;
    }

    public JMenuBar getJMenuBar() {
        return this;
    }

    private void readStopList() {
        List<String> lines;
        this.stopList.clear();
        try {
            CyApplicationConfiguration applicationConfig = (CyApplicationConfiguration)this.registrar.getService(CyApplicationConfiguration.class);
            if (applicationConfig == null) {
                return;
            }
            File configDirectory = applicationConfig.getConfigurationDirectoryLocation();
            File configFile = null;
            if (configDirectory.exists()) {
                configFile = new File(configDirectory.toPath() + "/menubar.stoplist");
            }
            if (configFile == null) {
                return;
            }
            lines = Files.readAllLines(configFile.toPath(), Charset.defaultCharset());
        }
        catch (IOException e) {
            return;
        }
        for (String line : lines) {
            this.stopList.add(line.trim());
        }
    }

    private void readMenuCustomizer() {
        List<String> lines;
        this.actionOverrideMap.clear();
        try {
            CyApplicationConfiguration applicationConfig = (CyApplicationConfiguration)this.registrar.getService(CyApplicationConfiguration.class);
            if (applicationConfig == null) {
                return;
            }
            File configDirectory = applicationConfig.getConfigurationDirectoryLocation();
            File configFile = null;
            if (configDirectory.exists()) {
                configFile = new File(configDirectory.toPath() + "/menubar.custom.txt");
            }
            if (configFile == null) {
                return;
            }
            lines = Files.readAllLines(configFile.toPath(), Charset.defaultCharset());
        }
        catch (IOException e) {
            return;
        }
        for (String line : lines) {
            this.addCustomizerRow(line.trim());
        }
    }

    private void addCustomizerRow(String trimmed) {
        String[] tokens = trimmed.split(TABSTR);
        assert (tokens.length == 8);
        String name = tokens[0];
        this.actionOverrideMap.put(name, trimmed);
    }
}

