/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.SwingPropertyChangeSupport;
import org.cytoscape.application.swing.CytoPanel;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelComponent2;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.application.swing.CytoPanelState;
import org.cytoscape.application.swing.events.CytoPanelComponentSelectedEvent;
import org.cytoscape.application.swing.events.CytoPanelStateChangedEvent;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.internal.view.CytoPanelNameInternal;
import org.cytoscape.internal.view.CytoPanelStateInternal;
import org.cytoscape.internal.view.CytoPanelUtil;
import org.cytoscape.internal.view.util.ViewUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.DropDownMenuButton;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.LookAndFeelUtil;

public class CytoPanelImpl
implements CytoPanel {
    public static final String TEXT_DOCK = "Dock";
    public static final String TEXT_UNDOCK = "Undock";
    public static final String TEXT_FLOAT = "Float";
    public static final String TEXT_MINIMIZE = "Minimize";
    public static final String TEXT_HIDE = "Hide";
    public static final float STATE_ICON_FONT_SIZE = 11.0f;
    private final int NOTIFICATION_STATE_CHANGE = 0;
    private final int NOTIFICATION_COMPONENT_SELECTED = 1;
    private JPanel mainPanel;
    private JPanel titlePanel;
    private DropDownMenuButton titleButton;
    private JButton floatButton;
    private JButton dockButton;
    private JButton undockButton;
    private JButton minimizeButton;
    private JPanel cardsPanel;
    private final CardLayout cardLayout = new CardLayout();
    private final CytoPanelNameInternal compassDirection;
    private final int trimBarIndex;
    private CytoPanelStateInternal state;
    private boolean maximized;
    private final List<CytoPanelComponent> cytoPanelComponents = new ArrayList<CytoPanelComponent>();
    private final Map<String, CytoPanelComponent2> componentsById = new HashMap<String, CytoPanelComponent2>();
    private final SwingPropertyChangeSupport pcs = new SwingPropertyChangeSupport(this, true);
    private final CyServiceRegistrar serviceRegistrar;

    public CytoPanelImpl(CytoPanelNameInternal compassDirection, int trimBarIndex, CytoPanelStateInternal state, CyServiceRegistrar serviceRegistrar) {
        this.compassDirection = compassDirection;
        this.trimBarIndex = trimBarIndex;
        this.serviceRegistrar = serviceRegistrar;
        this.update();
        this.setStateInternal(state);
    }

    String getTitle() {
        return this.compassDirection.getTitle();
    }

    public CytoPanelName getCytoPanelName() {
        return this.compassDirection.toCytoPanelName();
    }

    public CytoPanelNameInternal getCytoPanelNameInternal() {
        return this.compassDirection;
    }

    public CytoPanelState getState() {
        return this.getCytoPanelComponentCount() > 0 ? this.state.toCytoPanelState() : CytoPanelState.HIDE;
    }

    public void setState(CytoPanelState newState) {
        if (newState == null) {
            throw new IllegalArgumentException("CytoPanelState must not be null.");
        }
        this.setStateInternal(CytoPanelStateInternal.valueOf(newState));
    }

    public CytoPanelStateInternal getStateInternal() {
        return this.state;
    }

    public void setStateInternal(CytoPanelStateInternal newState) {
        if (newState == null) {
            throw new IllegalArgumentException("'newState' must not be null.");
        }
        if (newState != this.state) {
            CytoPanelState oldApiState = this.getState();
            CytoPanelStateInternal oldState = this.state;
            this.state = newState;
            this.update();
            if (this.pcs.hasListeners("stateInternal")) {
                this.pcs.firePropertyChange("stateInternal", (Object)oldState, (Object)newState);
            }
            if (oldApiState != this.getState()) {
                this.notifyListeners(0);
            }
        }
    }

    public int getTrimBarIndex() {
        return this.trimBarIndex;
    }

    public boolean insert(CytoPanelComponent cpc, int index) {
        if (this.indexOfComponent(cpc.getComponent()) >= 0) {
            return false;
        }
        CytoPanelState oldState = this.getState();
        this.cytoPanelComponents.add(index, cpc);
        if (cpc instanceof CytoPanelComponent2) {
            CytoPanelComponent2 comp2 = (CytoPanelComponent2)cpc;
            if (comp2.getIdentifier() == null) {
                throw new NullPointerException("'CytoPanelComponent2.identifier' must not be null");
            }
            this.componentsById.put(comp2.getIdentifier(), comp2);
        }
        this.checkSizes(cpc.getComponent());
        this.getCardsPanel().add(cpc.getComponent(), this.getIdentifier(cpc));
        this.update();
        if (oldState != this.getState()) {
            this.notifyListeners(0);
        }
        return true;
    }

    public int getCytoPanelComponentCount() {
        return this.cytoPanelComponents.size();
    }

    public Component getSelectedComponent() {
        for (Component c : this.getCardsPanel().getComponents()) {
            if (!c.isVisible()) continue;
            return c;
        }
        return null;
    }

    public Component getComponentAt(int index) {
        CytoPanelComponent cpc = this.getCytoPanelComponentAt(index);
        return cpc != null ? cpc.getComponent() : null;
    }

    public CytoPanelComponent getCytoPanelComponentAt(int index) {
        return index >= 0 && this.cytoPanelComponents.size() > index ? this.cytoPanelComponents.get(index) : null;
    }

    public int getSelectedIndex() {
        return this.indexOfComponent(this.getSelectedComponent());
    }

    public int indexOfComponent(Component component) {
        int i = 0;
        for (CytoPanelComponent cpc : this.cytoPanelComponents) {
            if (cpc.getComponent().equals(component)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int indexOfComponent(String identifier) {
        CytoPanelComponent cpc = (CytoPanelComponent)this.componentsById.get(identifier);
        return cpc != null ? this.indexOfComponent(cpc.getComponent()) : -1;
    }

    public boolean remove(CytoPanelComponent comp) {
        CytoPanelState oldState = this.getState();
        boolean removed = this.cytoPanelComponents.remove(comp);
        this.getCardsPanel().remove(comp.getComponent());
        if (comp instanceof CytoPanelComponent2) {
            this.componentsById.remove(((CytoPanelComponent2)comp).getIdentifier());
        }
        if (removed) {
            this.update();
            if (oldState != this.getState()) {
                this.notifyListeners(0);
            }
        }
        return removed;
    }

    public List<CytoPanelComponent> getCytoPanelComponents() {
        return new ArrayList<CytoPanelComponent>(this.cytoPanelComponents);
    }

    public void clear() {
        this.getCardsPanel().removeAll();
        this.cytoPanelComponents.clear();
        this.componentsById.clear();
    }

    public void setSelectedIndex(int index) {
        CytoPanelComponent cpc = this.getCytoPanelComponentAt(index);
        this.setSelectedComponent(cpc);
    }

    public void setSelectedComponent(CytoPanelComponent cpc) {
        if (cpc != null) {
            this.cardLayout.show(this.getCardsPanel(), this.getIdentifier(cpc));
            this.updateTitleButton();
            this.notifyListeners(1);
        }
    }

    public Component getThisComponent() {
        return this.getMainPanel();
    }

    public boolean isMaximized() {
        return this.maximized;
    }

    public void setMaximized(boolean maximized) {
        this.maximized = maximized;
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    private void checkSizes(Component comp) {
        if (this.compassDirection == CytoPanelNameInternal.WEST) {
            comp.setMinimumSize(new Dimension(100, 100));
        } else if (this.compassDirection == CytoPanelNameInternal.SOUTH) {
            comp.setMinimumSize(new Dimension(500, 50));
        } else if (this.compassDirection == CytoPanelNameInternal.EAST) {
            comp.setMinimumSize(new Dimension(100, 100));
        } else if (this.compassDirection == CytoPanelNameInternal.BOTTOM) {
            comp.setMinimumSize(new Dimension(100, 32));
        }
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder());
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getTitlePanel(), "North");
            this.mainPanel.add((Component)this.getCardsPanel(), "Center");
        }
        return this.mainPanel;
    }

    JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
            this.titlePanel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("Separator.foreground")));
            GroupLayout layout = new GroupLayout(this.titlePanel);
            this.titlePanel.setLayout(layout);
            layout.setAutoCreateContainerGaps(false);
            layout.setAutoCreateGaps(true);
            layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.getTitleButton(), -2, -1, -2).addGap(20, 20, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.getFloatButton(), -2, -1, -2).addComponent(this.getDockButton(), -2, -1, -2).addComponent(this.getUndockButton(), -2, -1, -2).addComponent(this.getMinimizeButton(), -2, -1, -2).addContainerGap());
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER, true).addComponent((Component)this.getTitleButton(), -2, -1, -2).addComponent(this.getFloatButton(), -2, -1, -2).addComponent(this.getDockButton(), -2, -1, -2).addComponent(this.getUndockButton(), -2, -1, -2).addComponent(this.getMinimizeButton(), -2, -1, -2));
        }
        return this.titlePanel;
    }

    private JPanel getCardsPanel() {
        if (this.cardsPanel == null) {
            this.cardsPanel = new JPanel(this.cardLayout);
        }
        return this.cardsPanel;
    }

    JButton getFloatButton() {
        if (this.floatButton == null) {
            this.floatButton = new JButton("\uf2d0");
            this.floatButton.setToolTipText(TEXT_FLOAT);
            CytoPanelUtil.styleButton(this.floatButton);
            this.floatButton.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(11.0f));
        }
        return this.floatButton;
    }

    JButton getUndockButton() {
        if (this.undockButton == null) {
            this.undockButton = new JButton(")");
            this.undockButton.setToolTipText(TEXT_UNDOCK);
            CytoPanelUtil.styleButton(this.undockButton);
            this.undockButton.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 11.0f));
        }
        return this.undockButton;
    }

    JButton getDockButton() {
        if (this.dockButton == null) {
            this.dockButton = new JButton("'");
            this.dockButton.setToolTipText(TEXT_DOCK);
            CytoPanelUtil.styleButton(this.dockButton);
            this.dockButton.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont("cytoscape-3", 11.0f));
        }
        return this.dockButton;
    }

    JButton getMinimizeButton() {
        if (this.minimizeButton == null) {
            this.minimizeButton = new JButton("\uf2d1");
            this.minimizeButton.setToolTipText(TEXT_MINIMIZE);
            CytoPanelUtil.styleButton(this.minimizeButton);
            this.minimizeButton.setFont(((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(11.0f));
        }
        return this.minimizeButton;
    }

    DropDownMenuButton getTitleButton() {
        if (this.titleButton == null) {
            this.titleButton = new DropDownMenuButton();
            this.titleButton.setHorizontalAlignment(2);
            this.titleButton.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.titleButton.setContentAreaFilled(false);
            LookAndFeelUtil.makeSmall((JComponent[])new JComponent[]{this.titleButton});
            this.titleButton.addActionListener(evt -> {
                if (this.getCytoPanelComponentCount() > 0) {
                    JPopupMenu popupMenu = new JPopupMenu();
                    int i = 0;
                    for (CytoPanelComponent cpc : this.cytoPanelComponents) {
                        int index = i++;
                        String title = cpc.getTitle();
                        Icon icon = cpc.getIcon();
                        if (icon == null) {
                            icon = ViewUtil.createDefaultIcon(title, 16, (IconManager)this.serviceRegistrar.getService(IconManager.class));
                        } else if (icon.getIconHeight() > 16) {
                            icon = ViewUtil.resizeIcon(icon, 16);
                        }
                        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(title, icon);
                        mi.setSelected(this.getSelectedIndex() == index);
                        mi.addActionListener(e -> this.setSelectedIndex(index));
                        popupMenu.add(mi);
                    }
                    popupMenu.show((Component)this.titleButton, 0, this.titleButton.getHeight());
                    popupMenu.requestFocusInWindow();
                }
            });
            this.updateTitleButton();
        }
        return this.titleButton;
    }

    private void notifyListeners(int notificationType) {
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        switch (notificationType) {
            case 0: {
                eventHelper.fireEvent((CyEvent)new CytoPanelStateChangedEvent((Object)this, (CytoPanel)this, this.getState()));
                break;
            }
            case 1: {
                int selectedIndex = this.getSelectedIndex();
                eventHelper.fireEvent((CyEvent)new CytoPanelComponentSelectedEvent((Object)this, (CytoPanel)this, selectedIndex));
            }
        }
    }

    void update() {
        this.updateTitleButton();
        this.getFloatButton().setVisible(this.state != CytoPanelStateInternal.FLOAT);
        this.getDockButton().setVisible(this.state != CytoPanelStateInternal.DOCK);
        this.getUndockButton().setVisible(this.state != CytoPanelStateInternal.UNDOCK);
        this.getMinimizeButton().setVisible(this.state != CytoPanelStateInternal.MINIMIZE);
        this.getThisComponent().setVisible(this.getCytoPanelComponentCount() > 0 && this.state != CytoPanelStateInternal.HIDE && this.state != CytoPanelStateInternal.MINIMIZE);
        this.getThisComponent().validate();
    }

    private void updateTitleButton() {
        Icon icon;
        int index = this.getSelectedIndex();
        CytoPanelComponent cpc = this.getCytoPanelComponentAt(index);
        String text = cpc != null && cpc.getTitle() != null ? cpc.getTitle().trim() : "";
        Icon icon2 = icon = cpc != null && text.isEmpty() ? cpc.getIcon() : null;
        if (icon != null && icon.getIconHeight() > 16) {
            icon = ViewUtil.resizeIcon(icon, 16);
        }
        this.getTitleButton().setText(text);
        this.getTitleButton().setIcon(icon);
        this.getTitleButton().setToolTipText(text);
        this.getTitleButton().setEnabled(this.getCytoPanelComponentCount() > 0);
        this.getTitleButton().setVisible(this.getCytoPanelComponentCount() > 0);
    }

    private String getIdentifier(CytoPanelComponent cpc) {
        if (cpc instanceof CytoPanelComponent2) {
            return ((CytoPanelComponent2)cpc).getIdentifier();
        }
        return cpc.getTitle() + "__" + cpc.getClass().getName();
    }

    public String toString() {
        return this.compassDirection.getTitle();
    }
}

