/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.view;

import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.cytoscape.application.swing.CyColumnPresentation;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.IconManager;
import org.cytoscape.util.swing.TextIcon;

public class CyColumnPresentationManagerImpl
implements CyColumnPresentationManager {
    private final CyServiceRegistrar serviceRegistrar;
    private final CyColumnPresentation cytoscapePresentation;
    private final Map<String, CyColumnPresentation> presentations = new HashMap<String, CyColumnPresentation>();

    public CyColumnPresentationManagerImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.cytoscapePresentation = this.getCytoscapePresentation(serviceRegistrar);
    }

    public void addPresentation(CyColumnPresentation presentation, Map<String, String> props) {
        String namespace = props.get("namespace");
        if (namespace != null) {
            this.presentations.put(namespace.toLowerCase(), presentation);
        }
    }

    public void removePresentation(CyColumnPresentation presentation, Map<String, String> props) {
        this.presentations.values().remove(presentation);
    }

    public CyColumnPresentation getColumnPresentation(String namespace) {
        if (namespace == null) {
            return this.cytoscapePresentation;
        }
        return this.presentations.computeIfAbsent(namespace.toLowerCase(), x$0 -> new DefaultPresentation((String)x$0));
    }

    private CyColumnPresentation getCytoscapePresentation(CyServiceRegistrar serviceRegistrar) {
        IconManager iconManager = (IconManager)serviceRegistrar.getService(IconManager.class);
        Font font = iconManager.getIconFont("cytoscape-3", 15.0f);
        Color color = new Color(254, 193, 125);
        TextIcon icon = new TextIcon("b", font, color, 16, 16);
        return new DefaultPresentation("Cytoscape", (Icon)icon);
    }

    private Icon createDefaultIcon(String namespace) {
        String letter = " ";
        if (!(namespace = namespace.trim()).isEmpty()) {
            letter = namespace.substring(0, 1).toUpperCase();
        }
        Color iconColor = CyColumnPresentationManagerImpl.getDefaultIconColor(namespace);
        Color textColor = CyColumnPresentationManagerImpl.getContrastingColor(iconColor);
        Font iconFont = ((IconManager)this.serviceRegistrar.getService(IconManager.class)).getIconFont(16.0f);
        Font textFont = new Font("SansSerif", 1, 12);
        return new TextIcon(new String[]{"\uf111", letter}, new Font[]{iconFont, textFont}, new Color[]{iconColor, textColor}, 16, 16);
    }

    private static Color getDefaultIconColor(String namespace) {
        int index = Math.abs(namespace.toLowerCase().hashCode() % 12);
        switch (index) {
            default: {
                return new Color(166, 206, 227);
            }
            case 1: {
                return new Color(31, 120, 180);
            }
            case 2: {
                return new Color(178, 223, 138);
            }
            case 3: {
                return new Color(51, 160, 44);
            }
            case 4: {
                return new Color(251, 154, 153);
            }
            case 5: {
                return new Color(227, 26, 28);
            }
            case 6: {
                return new Color(253, 191, 111);
            }
            case 7: {
                return new Color(255, 127, 0);
            }
            case 8: {
                return new Color(202, 178, 214);
            }
            case 9: {
                return new Color(106, 61, 154);
            }
            case 10: {
                return new Color(255, 255, 153);
            }
            case 11: 
        }
        return new Color(177, 89, 40);
    }

    private static Color getContrastingColor(Color color) {
        int d = 0;
        double a = 1.0 - (0.299 * (double)color.getRed() + 0.587 * (double)color.getGreen() + 0.114 * (double)color.getBlue()) / 255.0;
        d = a < 0.5 ? 0 : 255;
        return new Color(d, d, d);
    }

    private class DefaultPresentation
    implements CyColumnPresentation {
        private final String namespace;
        private final Icon icon;

        public DefaultPresentation(String namespace, Icon icon) {
            this.namespace = namespace;
            this.icon = icon == null ? CyColumnPresentationManagerImpl.this.createDefaultIcon(namespace) : icon;
        }

        public DefaultPresentation(String namespace) {
            this(namespace, null);
        }

        public String getNamespaceDescription() {
            return this.namespace;
        }

        public Icon getNamespaceIcon() {
            return this.icon;
        }
    }
}

