/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.util;

import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JOptionPane;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.NetworkViewRenderer;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.read.OpenSessionTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.view.model.VisualLexicon;
import org.cytoscape.view.model.VisualProperty;
import org.cytoscape.view.presentation.RenderingEngineFactory;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

public final class Util {
    public static boolean same(Object obj1, Object obj2) {
        return obj1 == null && obj2 == null || obj1 != null && obj1.equals(obj2);
    }

    public static boolean equalSets(Collection<?> list1, Collection<?> list2) {
        HashSet set2;
        HashSet set1;
        if ((list1 == null || list1.isEmpty()) && (list2 == null || list2.isEmpty())) {
            return true;
        }
        return list1 != null && list2 != null && (set1 = new HashSet(list1)).equals(set2 = new HashSet(list2));
    }

    public static Set<CyNetwork> getNetworks(Collection<CyNetworkView> views) {
        LinkedHashSet<CyNetwork> networks = new LinkedHashSet<CyNetwork>();
        for (CyNetworkView v : views) {
            networks.add((CyNetwork)v.getModel());
        }
        return networks;
    }

    public static Set<CyNetworkView> getNetworkViews(Collection<CyNetwork> networks, CyServiceRegistrar serviceRegistrar) {
        LinkedHashSet<CyNetworkView> views = new LinkedHashSet<CyNetworkView>();
        CyNetworkViewManager netViewMgr = (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class);
        for (CyNetwork n : networks) {
            views.addAll(netViewMgr.getNetworkViews(n));
        }
        return views;
    }

    public static boolean isDisposed(CyNetworkView view) {
        return ((CyNetwork)view.getModel()).getDefaultNodeTable() == null || ((CyNetwork)view.getModel()).getDefaultEdgeTable() == null;
    }

    public static boolean isVisualPropertySupported(String vpId, Class<?> type, CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        if (view == null) {
            return false;
        }
        VisualLexicon lexicon = Util.getVisualLexicon(view, serviceRegistrar);
        if (lexicon == null) {
            return false;
        }
        VisualProperty vp = lexicon.lookup(type, vpId);
        return vp != null && lexicon.isSupported(vp);
    }

    public static void setLockedValue(String vpId, Class<?> type, Object value, CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        if (view == null) {
            return;
        }
        VisualLexicon lexicon = Util.getVisualLexicon(view, serviceRegistrar);
        if (lexicon == null) {
            return;
        }
        VisualProperty vp = lexicon.lookup(type, vpId);
        if (vp != null && lexicon.isSupported(vp)) {
            view.setLockedValue(vp, value);
        }
    }

    public static Object getVisualProperty(String vpId, Class<?> type, CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        VisualProperty vp;
        VisualLexicon lexicon;
        if (view != null && (lexicon = Util.getVisualLexicon(view, serviceRegistrar)) != null && (vp = lexicon.lookup(type, vpId)) != null && lexicon.isSupported(vp)) {
            return view.getVisualProperty(vp);
        }
        return null;
    }

    public static VisualLexicon getVisualLexicon(CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        CyApplicationManager applicationManager = (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class);
        NetworkViewRenderer renderer = applicationManager.getNetworkViewRenderer(view.getRendererId());
        RenderingEngineFactory factory = renderer == null ? null : renderer.getRenderingEngineFactory("");
        return factory == null ? null : factory.getVisualLexicon();
    }

    public static double squarenessRatio(double w, double h) {
        return Math.abs(1.0 - (w > h ? w / h : h / w));
    }

    public static void maybeOpenSession(File file, Component owner, CyServiceRegistrar serviceRegistrar) {
        Util.maybeOpenSession(file, owner, serviceRegistrar, null);
    }

    public static void maybeOpenSession(File file, Component owner, CyServiceRegistrar serviceRegistrar, TaskObserver observer) {
        if (file.exists() && file.canRead()) {
            CyNetworkManager netManager = (CyNetworkManager)serviceRegistrar.getService(CyNetworkManager.class);
            CyTableManager tableManager = (CyTableManager)serviceRegistrar.getService(CyTableManager.class);
            if (netManager.getNetworkSet().isEmpty() && tableManager.getAllTables(false).isEmpty()) {
                Util.openSession(file, serviceRegistrar, observer);
            } else {
                Util.openSessionWithWarning(file, owner, serviceRegistrar, observer);
            }
        }
    }

    public static void openSession(File file, CyServiceRegistrar serviceRegistrar, TaskObserver observer) {
        OpenSessionTaskFactory taskFactory = (OpenSessionTaskFactory)serviceRegistrar.getService(OpenSessionTaskFactory.class);
        DialogTaskManager taskManager = (DialogTaskManager)serviceRegistrar.getService(DialogTaskManager.class);
        if (observer == null) {
            taskManager.execute(taskFactory.createTaskIterator(file));
        } else {
            taskManager.execute(taskFactory.createTaskIterator(file), observer);
        }
    }

    public static void openSessionWithWarning(File file, Component owner, CyServiceRegistrar serviceRegistrar, TaskObserver observer) {
        if (JOptionPane.showConfirmDialog(owner, "Current session (all networks and tables) will be lost.\nDo you want to continue?", "Open Session", 2) == 0) {
            Util.openSession(file, serviceRegistrar, observer);
        }
    }

    public static URL getURL(String s) {
        try {
            if (s != null) {
                return new URL(s);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private Util() {
    }
}

