/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.task;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CytoPanelComponent;
import org.cytoscape.application.swing.CytoPanelName;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.TaskFactory;
import org.cytoscape.work.TunableValidator;
import org.cytoscape.work.swing.PanelTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CytoPanelTaskFactoryTunableAction
extends AbstractCyAction {
    private final TaskFactory factory;
    private final Object context;
    private final Map<String, String> serviceProps;
    private final CytoPanelName cytoPanelName;
    private final CyServiceRegistrar serviceRegistrar;
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");

    public CytoPanelTaskFactoryTunableAction(TaskFactory factory, Object context, Map<String, String> serviceProps, CyServiceRegistrar serviceRegistrar) {
        super(serviceProps, (CyApplicationManager)serviceRegistrar.getService(CyApplicationManager.class), (CyNetworkViewManager)serviceRegistrar.getService(CyNetworkViewManager.class));
        this.factory = factory;
        this.serviceProps = serviceProps;
        this.serviceRegistrar = serviceRegistrar;
        this.cytoPanelName = this.getCytoPanelName();
        this.context = context;
    }

    private CytoPanelName getCytoPanelName() {
        CytoPanelName n = null;
        try {
            String name = this.serviceProps.get("preferredCytoPanel");
            n = name != null ? CytoPanelName.valueOf((String)name.toString()) : CytoPanelName.WEST;
        }
        catch (Exception e) {
            logger.warn("couldn't find 'preferredCytoPanel' property", (Throwable)e);
            n = CytoPanelName.WEST;
        }
        return n;
    }

    public void actionPerformed(ActionEvent a) {
        PanelTaskManager taskManager = (PanelTaskManager)this.serviceRegistrar.getService(PanelTaskManager.class);
        JPanel innerPanel = (JPanel)taskManager.getConfiguration(this.factory, this.context);
        if (innerPanel == null) {
            return;
        }
        CytoPanelComponentImp imp = new CytoPanelComponentImp(innerPanel, this.getCytoPanelComponentTitle());
        this.serviceRegistrar.registerService((Object)imp, CytoPanelComponent.class, new Properties());
    }

    private String getCytoPanelComponentTitle() {
        try {
            String cytoPanelComponentTitle = this.serviceProps.get("cytoPanelComponentTitle");
            if (cytoPanelComponentTitle != null) {
                return cytoPanelComponentTitle;
            }
            String menuTitle = this.serviceProps.get("title");
            if (menuTitle != null) {
                if (menuTitle.endsWith("...")) {
                    return menuTitle.substring(0, menuTitle.length() - 3);
                }
                return menuTitle;
            }
            return "*No Title*";
        }
        catch (ClassCastException e) {
            logger.error("This should *never* happen.", (Throwable)e);
            return "*Missing Title*";
        }
    }

    private static class ExecuteButtonListener
    implements ActionListener {
        private final TaskFactory factory;
        private final Object context;
        private CyServiceRegistrar serviceRegistrar;

        ExecuteButtonListener(TaskFactory factory, Object context, CyServiceRegistrar serviceRegistrar) {
            this.factory = factory;
            this.context = context;
            this.serviceRegistrar = serviceRegistrar;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.context instanceof TunableValidator) {
                StringBuilder errMsg = new StringBuilder();
                try {
                    TunableValidator.ValidationState validationState = ((TunableValidator)this.context).getValidationState((Appendable)errMsg);
                    if (validationState == TunableValidator.ValidationState.INVALID) {
                        JOptionPane.showMessageDialog(new JFrame(), errMsg.toString(), "Input Validation Problem", 0);
                        return;
                    }
                    if (validationState == TunableValidator.ValidationState.REQUEST_CONFIRMATION && JOptionPane.showConfirmDialog(new JFrame(), errMsg.toString(), "Request Confirmation", 0) == 1) {
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            PanelTaskManager taskManager = (PanelTaskManager)this.serviceRegistrar.getService(PanelTaskManager.class);
            taskManager.execute(this.factory.createTaskIterator());
        }
    }

    private class CytoPanelComponentImp
    implements CytoPanelComponent {
        private final Component innerPanel;
        private final Component comp;
        private final String title;

        CytoPanelComponentImp(Component innerPanel, String title) {
            this.innerPanel = innerPanel;
            this.title = title;
            this.comp = this.createComponent();
        }

        public String getTitle() {
            return this.title;
        }

        public CytoPanelName getCytoPanelName() {
            return CytoPanelTaskFactoryTunableAction.this.cytoPanelName;
        }

        public Icon getIcon() {
            return null;
        }

        public Component getComponent() {
            return this.comp;
        }

        private Component createComponent() {
            JPanel outerPanel = new JPanel();
            outerPanel.add(this.innerPanel);
            JButton executeButton = new JButton("Execute");
            executeButton.addActionListener(new ExecuteButtonListener(CytoPanelTaskFactoryTunableAction.this.factory, CytoPanelTaskFactoryTunableAction.this.context, CytoPanelTaskFactoryTunableAction.this.serviceRegistrar));
            outerPanel.add(executeButton);
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(evt -> CytoPanelTaskFactoryTunableAction.this.serviceRegistrar.unregisterService((Object)this, CytoPanelComponent.class));
            outerPanel.add(closeButton);
            return outerPanel;
        }
    }
}

