/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.select;

import java.util.Map;
import org.cytoscape.internal.select.RowViewTracker;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.events.RowSetRecord;
import org.cytoscape.model.events.RowsSetEvent;
import org.cytoscape.model.events.RowsSetListener;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.model.VisualProperty;

public abstract class AbstractViewUpdater<S>
implements RowsSetListener {
    protected final VisualProperty<S> vp;
    protected final String columnName;
    private final RowViewTracker tracker;

    public AbstractViewUpdater(VisualProperty<S> vp, String columnName, RowViewTracker tracker) {
        this.vp = vp;
        this.columnName = columnName;
        this.tracker = tracker;
    }

    public void handleEvent(RowsSetEvent e) {
        CyTable cyTable = (CyTable)e.getSource();
        for (CyNetworkView networkView : this.tracker.getAffectedNetworkViews(cyTable)) {
            Map<CyRow, View<? extends CyIdentifiable>> rowViewMap = this.tracker.getRowViewMap(networkView);
            for (RowSetRecord record : e.getColumnRecords(this.columnName)) {
                View<? extends CyIdentifiable> v = rowViewMap.get(record.getRow());
                if (v == null) continue;
                v.setVisualProperty(this.vp, record.getValue());
            }
        }
    }
}

