/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.model;

import java.util.Collection;
import java.util.LinkedHashSet;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedEvent;
import org.cytoscape.model.events.NetworkAboutToBeDestroyedListener;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.model.subnetwork.CySubNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.events.SessionAboutToBeLoadedEvent;
import org.cytoscape.session.events.SessionAboutToBeLoadedListener;

public class RootNetworkManager
implements NetworkAboutToBeDestroyedListener,
SessionAboutToBeLoadedListener {
    private final Collection<CyRootNetwork> selectedRootNetworks = new LinkedHashSet<CyRootNetwork>();
    private final Object lock = new Object();
    private final CyServiceRegistrar serviceRegistrar;

    public RootNetworkManager(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public Collection<CyRootNetwork> getSelectedRootNetworks() {
        return new LinkedHashSet<CyRootNetwork>(this.selectedRootNetworks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedRootNetworks(Collection<CyRootNetwork> rootNetworks) {
        Object object = this.lock;
        synchronized (object) {
            this.selectedRootNetworks.clear();
            if (rootNetworks != null && !rootNetworks.isEmpty()) {
                this.selectedRootNetworks.addAll(rootNetworks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(NetworkAboutToBeDestroyedEvent evt) {
        CyNetwork net = evt.getNetwork();
        CyRootNetwork rootNet = ((CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class)).getRootNetwork(net);
        Object object = this.lock;
        synchronized (object) {
            if (!this.selectedRootNetworks.contains(rootNet)) {
                return;
            }
        }
        CyNetworkManager netManager = (CyNetworkManager)this.serviceRegistrar.getService(CyNetworkManager.class);
        for (CySubNetwork sn : rootNet.getSubNetworkList()) {
            if (sn.getSUID().equals(net.getSUID()) || !netManager.networkExists(sn.getSUID().longValue())) continue;
            return;
        }
        Object object2 = this.lock;
        synchronized (object2) {
            this.selectedRootNetworks.remove(rootNet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(SessionAboutToBeLoadedEvent evt) {
        Object object = this.lock;
        synchronized (object) {
            this.selectedRootNetworks.clear();
        }
    }
}

