/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.layout.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.cytoscape.property.AbstractConfigDirPropsReader;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.layout.CyLayoutAlgorithmManager;
import org.cytoscape.work.properties.TunablePropertySerializer;
import org.cytoscape.work.properties.TunablePropertySerializerFactory;
import org.cytoscape.work.swing.PanelTaskManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutSettingsManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"org.cytoscape.application.userlog");
    private static final String LAYOUT_ATTRIBUTE_PROP = "cy.layoutAttribute";
    private final CyServiceRegistrar serviceRegistrar;
    private final Map<String, CyProperty<Properties>> registeredPropertyServices = new HashMap<String, CyProperty<Properties>>();
    private ExecutorService executorService;

    public LayoutSettingsManager(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.executorService = Executors.newCachedThreadPool();
    }

    public void addLayout(CyLayoutAlgorithm layout, Map<?, ?> props) {
        this.executorService.execute(() -> this.restoreLayoutContext(layout));
    }

    public void removeLayout(CyLayoutAlgorithm layout, Map<?, ?> props) {
    }

    public void restoreLayoutContext(CyLayoutAlgorithm layout) {
        try {
            Object layoutContext = layout.getDefaultLayoutContext();
            CyProperty<Properties> cyProperty = this.getPropertyService(layout);
            Properties propsBefore = (Properties)cyProperty.getProperties();
            if (!propsBefore.isEmpty()) {
                TunablePropertySerializerFactory serializerFactory = (TunablePropertySerializerFactory)this.serviceRegistrar.getService(TunablePropertySerializerFactory.class);
                TunablePropertySerializer serializer = serializerFactory.createSerializer();
                serializer.setTunables(layoutContext, propsBefore);
            }
            CyLayoutAlgorithmManager layoutManager = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
            String layoutAttribute = propsBefore.getProperty(LAYOUT_ATTRIBUTE_PROP);
            layoutManager.setLayoutAttribute(layout, layoutAttribute);
        }
        catch (Exception e) {
            logger.error("Error restoring layout settings for '" + layout.getName() + "'", (Throwable)e);
        }
    }

    public void clearLayoutContext(PanelTaskManager taskMgr, CyLayoutAlgorithm layout) {
        try {
            CyProperty<Properties> cyProperty = this.getPropertyService(layout);
            ((Properties)cyProperty.getProperties()).clear();
        }
        catch (Exception e) {
            logger.error("Error saving layout settings for '" + layout.getName() + "'", (Throwable)e);
        }
    }

    public void saveLayoutContext(PanelTaskManager taskMgr, CyLayoutAlgorithm layout) {
        Object layoutContext = layout.getDefaultLayoutContext();
        this.saveLayoutContext(taskMgr, layout, layoutContext);
    }

    public void saveLayoutContext(PanelTaskManager taskMgr, CyLayoutAlgorithm layout, Object layoutContext) {
        try {
            taskMgr.validateAndApplyTunables(layoutContext);
            CyLayoutAlgorithmManager layoutManager = (CyLayoutAlgorithmManager)this.serviceRegistrar.getService(CyLayoutAlgorithmManager.class);
            String layoutAttribute = layoutManager.getLayoutAttribute(layout, null);
            TunablePropertySerializerFactory serializerFactory = (TunablePropertySerializerFactory)this.serviceRegistrar.getService(TunablePropertySerializerFactory.class);
            TunablePropertySerializer serializer = serializerFactory.createSerializer();
            Properties layoutProps = serializer.toProperties(layoutContext);
            if (layoutAttribute != null) {
                layoutProps.put(LAYOUT_ATTRIBUTE_PROP, layoutAttribute);
            }
            if (!layoutProps.isEmpty()) {
                CyProperty<Properties> cyProperty = this.getPropertyService(layout);
                ((Properties)cyProperty.getProperties()).clear();
                ((Properties)cyProperty.getProperties()).putAll((Map<?, ?>)layoutProps);
            }
        }
        catch (Exception e) {
            logger.error("Error saving layout settings for '" + layout.getName() + "'", (Throwable)e);
        }
    }

    private synchronized CyProperty<Properties> getPropertyService(CyLayoutAlgorithm layout) {
        Object service = this.registeredPropertyServices.get(layout.getName());
        if (service == null) {
            service = PropsReader.forLayout(layout);
            Properties serviceProps = new Properties();
            serviceProps.setProperty("cyPropertyName", service.getName());
            this.serviceRegistrar.registerAllServices(service, serviceProps);
            this.registeredPropertyServices.put(layout.getName(), (CyProperty<Properties>)service);
        }
        return service;
    }

    private static class PropsReader
    extends AbstractConfigDirPropsReader {
        public PropsReader(String name, String fileName) {
            super(name, fileName, CyProperty.SavePolicy.CONFIG_DIR);
        }

        public static PropsReader forLayout(CyLayoutAlgorithm layout) {
            String name = "layout." + layout.getName();
            return new PropsReader(name, name + ".props");
        }
    }
}

