/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.layout.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.internal.layout.ui.DynamicLayoutMenu;
import org.cytoscape.internal.layout.ui.StaticLayoutMenu;
import org.cytoscape.internal.view.CytoscapeMenuBar;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.util.swing.GravityTracker;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.swing.DialogTaskManager;

public class LayoutMenuPopulator
implements MenuListener {
    private Map<CyLayoutAlgorithm, Map> algorithmMap = new HashMap<CyLayoutAlgorithm, Map>();
    private Map<CyLayoutAlgorithm, JMenuItem> menuMap = new HashMap<CyLayoutAlgorithm, JMenuItem>();
    private Map<CyLayoutAlgorithm, Boolean> separatorMap = new HashMap<CyLayoutAlgorithm, Boolean>();
    private GravityTracker gravityTracker;
    private JMenu layoutMenu;
    private final CyServiceRegistrar serviceRegistrar;

    public LayoutMenuPopulator(CytoscapeMenuBar menuBar, CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
        this.gravityTracker = menuBar.getMenuTracker().getGravityTracker("Layout");
        this.layoutMenu = (JMenu)this.gravityTracker.getMenu();
        this.layoutMenu.addMenuListener(this);
    }

    public void addLayout(CyLayoutAlgorithm layout, Map props) {
        this.algorithmMap.put(layout, props);
    }

    public void removeLayout(CyLayoutAlgorithm layout, Map props) {
        this.algorithmMap.remove(layout);
        if (this.menuMap.containsKey(layout)) {
            this.layoutMenu.remove(this.menuMap.remove(layout));
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        DialogTaskManager tm = (DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class);
        CyNetworkView view = appMgr.getCurrentNetworkView();
        CyNetwork network = appMgr.getCurrentNetwork();
        boolean someSelected = false;
        if (network != null) {
            someSelected = network.getDefaultNodeTable().countMatchingRows("selected", (Object)true) > 0;
        }
        boolean enableMenuItem = this.checkEnabled();
        for (CyLayoutAlgorithm layout : this.algorithmMap.keySet()) {
            JMenuItem newMenu;
            boolean usesSelected;
            Map props = this.algorithmMap.get(layout);
            double gravity = 1000.0;
            if (props.get("menuGravity") != null) {
                gravity = Double.parseDouble((String)props.get("menuGravity"));
            }
            boolean separatorAfter = false;
            if (props.get("insertSeparatorAfter") != null) {
                separatorAfter = Boolean.parseBoolean((String)props.get("insertSeparatorAfter"));
            }
            boolean separatorBefore = false;
            if (props.get("insertSeparatorBefore") != null) {
                separatorBefore = Boolean.parseBoolean((String)props.get("insertSeparatorBefore"));
            }
            if (this.menuMap.containsKey(layout)) {
                this.layoutMenu.remove(this.menuMap.remove(layout));
            }
            boolean usesNodeAttrs = false;
            if (network != null) {
                usesNodeAttrs = this.hasValidAttributes(layout.getSupportedNodeAttributeTypes(), network.getDefaultNodeTable());
            }
            boolean usesEdgeAttrs = false;
            if (network != null) {
                usesEdgeAttrs = this.hasValidAttributes(layout.getSupportedEdgeAttributeTypes(), network.getDefaultEdgeTable());
            }
            boolean bl = usesSelected = layout.getSupportsSelectedOnly() && someSelected;
            if (usesNodeAttrs || usesEdgeAttrs || usesSelected) {
                newMenu = new DynamicLayoutMenu(layout, network, enableMenuItem, this.serviceRegistrar, tm, usesNodeAttrs, usesEdgeAttrs, usesSelected);
                this.menuMap.put(layout, newMenu);
                this.gravityTracker.addMenu((JMenu)newMenu, gravity);
            } else {
                newMenu = new StaticLayoutMenu(layout, enableMenuItem, appMgr, tm);
                this.menuMap.put(layout, newMenu);
                this.gravityTracker.addMenuItem(newMenu, gravity);
            }
            if (separatorAfter && !this.separatorMap.containsKey(layout)) {
                this.gravityTracker.addMenuSeparator(gravity + 1.0E-4);
                this.separatorMap.put(layout, Boolean.TRUE);
                continue;
            }
            if (!separatorBefore || this.separatorMap.containsKey(layout)) continue;
            this.gravityTracker.addMenuSeparator(gravity - 1.0E-4);
            this.separatorMap.put(layout, Boolean.TRUE);
        }
    }

    private boolean hasValidAttributes(Set<Class<?>> typeSet, CyTable attributes) {
        for (CyColumn column : attributes.getColumns()) {
            if (!typeSet.contains(column.getType())) continue;
            return true;
        }
        return false;
    }

    private boolean checkEnabled() {
        CyApplicationManager appMgr = (CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class);
        CyNetwork network = appMgr.getCurrentNetwork();
        if (network == null) {
            return false;
        }
        CyNetworkView view = appMgr.getCurrentNetworkView();
        return view != null;
    }
}

