/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.layout.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.CyColumnPresentationManager;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableUtil;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.layout.CyLayoutAlgorithm;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.View;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.swing.DialogTaskManager;

public class DynamicLayoutMenu
extends JMenu
implements MenuListener {
    private static final long serialVersionUID = 1202339874245069L;
    private final CyLayoutAlgorithm layout;
    private final DialogTaskManager tm;
    private final boolean usesNodeAttrs;
    private final boolean usesEdgeAttrs;
    private final boolean supportsSelectedOnly;
    private final CyServiceRegistrar serviceRegistrar;
    private final WeakReference<CyNetwork> networkRef;
    private static final String UNWEIGHTED = "(none)";

    public DynamicLayoutMenu(CyLayoutAlgorithm layout, CyNetwork network, boolean enabled, CyServiceRegistrar serviceRegistrar, DialogTaskManager tm, boolean usesNodeAttrs, boolean usesEdgeAttrs, boolean supportsSelectedOnly) {
        super(layout.toString());
        this.layout = layout;
        this.networkRef = new WeakReference<CyNetwork>(network);
        this.tm = tm;
        this.serviceRegistrar = serviceRegistrar;
        this.addMenuListener(this);
        this.setEnabled(enabled);
        this.supportsSelectedOnly = supportsSelectedOnly;
        this.usesNodeAttrs = usesNodeAttrs;
        this.usesEdgeAttrs = usesEdgeAttrs;
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        this.removeAll();
        if (this.supportsSelectedOnly) {
            this.addSelectedOnlyMenus(this);
        } else if (this.usesNodeAttrs) {
            this.addNodeAttributeMenus(this, false);
        } else if (this.usesEdgeAttrs) {
            this.addEdgeAttributeMenus(this, false);
        } else {
            throw new RuntimeException("Layout algorithm expected valid table columns or selected");
        }
    }

    private void addNodeAttributeMenus(JMenu parent, boolean selectedOnly) {
        CyNetwork network = (CyNetwork)this.networkRef.get();
        if (network != null) {
            CyTable nodeAttributes = network.getDefaultNodeTable();
            this.addAttributeMenus(parent, nodeAttributes, this.layout.getSupportedNodeAttributeTypes(), selectedOnly);
        }
    }

    private void addEdgeAttributeMenus(JMenu parent, boolean selectedOnly) {
        CyNetwork network = (CyNetwork)this.networkRef.get();
        if (network != null) {
            CyTable edgeAttributes = network.getDefaultEdgeTable();
            this.addAttributeMenus(parent, edgeAttributes, this.layout.getSupportedEdgeAttributeTypes(), selectedOnly);
        }
    }

    private void addAttributeMenus(JMenu parent, CyTable attributes, Set<Class<?>> typeSet, boolean selectedOnly) {
        parent.add(new LayoutAttributeMenuItem(UNWEIGHTED, selectedOnly));
        for (CyColumn column : attributes.getColumns()) {
            if (!typeSet.contains(column.getType())) continue;
            parent.add(new LayoutAttributeMenuItem(column, selectedOnly));
        }
    }

    private void addSelectedOnlyMenus(JMenu parent) {
        JMenuItem selNodes;
        JMenuItem allNodes;
        if (this.usesNodeAttrs || this.usesEdgeAttrs) {
            allNodes = new JMenu("All Nodes");
            selNodes = new JMenu("Selected Nodes Only");
            if (this.usesNodeAttrs) {
                this.addNodeAttributeMenus((JMenu)allNodes, false);
                this.addNodeAttributeMenus((JMenu)selNodes, true);
            } else {
                this.addEdgeAttributeMenus((JMenu)allNodes, false);
                this.addEdgeAttributeMenus((JMenu)selNodes, true);
            }
        } else {
            allNodes = new LayoutAttributeMenuItem("All Nodes", false);
            selNodes = new LayoutAttributeMenuItem("Selected Nodes Only", true);
        }
        parent.add(allNodes);
        parent.add(selNodes);
    }

    protected class LayoutAttributeMenuItem
    extends JMenuItem
    implements ActionListener {
        private static final long serialVersionUID = 1202339874231860L;
        boolean selectedOnly;

        public LayoutAttributeMenuItem(String label, boolean selectedOnly) {
            super(label);
            this.selectedOnly = false;
            this.addActionListener(this);
            this.selectedOnly = selectedOnly;
        }

        public LayoutAttributeMenuItem(CyColumn column, boolean selectedOnly) {
            this.selectedOnly = false;
            this.addActionListener(this);
            this.selectedOnly = selectedOnly;
            CyColumnPresentationManager presentationMgr = (CyColumnPresentationManager)DynamicLayoutMenu.this.serviceRegistrar.getService(CyColumnPresentationManager.class);
            presentationMgr.setLabel(column.getName(), this::setIcon, this::setText);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CyApplicationManager appMgr = (CyApplicationManager)DynamicLayoutMenu.this.serviceRegistrar.getService(CyApplicationManager.class);
            List views = appMgr.getSelectedNetworkViews();
            for (CyNetworkView netView : views) {
                Set<View<CyNode>> nodeViews = DynamicLayoutMenu.this.layout.getSupportsSelectedOnly() && this.selectedOnly ? this.getSelectedNodeViews(netView) : CyLayoutAlgorithm.ALL_NODE_VIEWS;
                String layoutAttribute = null;
                if ((DynamicLayoutMenu.this.layout.getSupportedNodeAttributeTypes().size() > 0 || DynamicLayoutMenu.this.layout.getSupportedEdgeAttributeTypes().size() > 0) && (layoutAttribute = e.getActionCommand()).equals(DynamicLayoutMenu.UNWEIGHTED)) {
                    layoutAttribute = null;
                }
                DynamicLayoutMenu.this.tm.execute(DynamicLayoutMenu.this.layout.createTaskIterator(netView, DynamicLayoutMenu.this.layout.getDefaultLayoutContext(), nodeViews, layoutAttribute));
            }
        }

        private Set<View<CyNode>> getSelectedNodeViews(CyNetworkView view) {
            List selectedNodes = CyTableUtil.getNodesInState((CyNetwork)((CyNetwork)view.getModel()), (String)"selected", (boolean)true);
            if (selectedNodes.isEmpty()) {
                return CyLayoutAlgorithm.ALL_NODE_VIEWS;
            }
            HashSet<View<CyNode>> nodeViews = new HashSet<View<CyNode>>();
            for (CyNode n : selectedNodes) {
                View nodeView = view.getNodeView(n);
                if (!((Boolean)nodeView.getVisualProperty(BasicVisualLexicon.NODE_VISIBLE)).booleanValue()) continue;
                nodeViews.add((View<CyNode>)nodeView);
            }
            return nodeViews;
        }
    }
}

