/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.event.PopupMenuEvent;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.write.ExportSelectedNetworkTaskFactory;
import org.cytoscape.work.swing.DialogTaskManager;

public class ExportNetworkAction
extends AbstractCyAction {
    private final CyServiceRegistrar serviceRegistrar;

    public ExportNetworkAction(float menuGravity, CyServiceRegistrar serviceRegistrar) {
        super("Export as Network...");
        this.serviceRegistrar = serviceRegistrar;
        this.insertSeparatorBefore = true;
        this.setMenuGravity(menuGravity);
    }

    public void actionPerformed(ActionEvent e) {
        ExportSelectedNetworkTaskFactory factory = (ExportSelectedNetworkTaskFactory)this.serviceRegistrar.getService(ExportSelectedNetworkTaskFactory.class);
        ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(factory.createTaskIterator());
    }

    public void updateEnableState() {
        List networks = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworks();
        CyNetwork currentNet = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
        this.setEnabled(networks.size() == 1 && ((CyNetwork)networks.get(0)).equals(currentNet));
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.updateEnableState();
    }
}

