/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.event.PopupMenuEvent;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.write.ExportNetworkImageTaskFactory;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.swing.DialogTaskManager;

public class ExportImageAction
extends AbstractCyAction {
    private final CyServiceRegistrar serviceRegistrar;

    public ExportImageAction(float menuGravity, CyServiceRegistrar serviceRegistrar) {
        super("Export as Image...");
        this.serviceRegistrar = serviceRegistrar;
        this.setMenuGravity(menuGravity);
    }

    public void actionPerformed(ActionEvent e) {
        List networks = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworks();
        if (networks.size() == 1) {
            ExportNetworkImageTaskFactory factory = (ExportNetworkImageTaskFactory)this.serviceRegistrar.getService(ExportNetworkImageTaskFactory.class);
            TaskIterator taskIterator = new TaskIterator(new Task[0]);
            Collection views = ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViews((CyNetwork)networks.get(0));
            if (!views.isEmpty()) {
                for (CyNetworkView nv : views) {
                    taskIterator.append(factory.createTaskIterator(nv));
                }
                ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(taskIterator);
            }
        }
    }

    public void updateEnableState() {
        List networks = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getSelectedNetworks();
        this.setEnabled(networks.size() == 1 && ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).viewExists((CyNetwork)networks.get(0)));
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        this.updateEnableState();
    }
}

