/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal.actions;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.util.Properties;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyVersion;
import org.cytoscape.application.events.CyStartEvent;
import org.cytoscape.application.events.CyStartListener;
import org.cytoscape.application.swing.AbstractCyAction;
import org.cytoscape.application.swing.CySwingApplication;
import org.cytoscape.internal.task.GetLatestVersionTask;
import org.cytoscape.internal.view.updater.UpdatesDialog;
import org.cytoscape.property.CyProperty;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.FinishStatus;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskObserver;
import org.cytoscape.work.swing.DialogTaskManager;

public class CheckForUpdatesAction
extends AbstractCyAction
implements CyStartListener {
    private static final String HIDE_UPDATES_PROP = "hideUpdatesNotification";
    private static final String TEMP_HIDE_PROP = "tempHideWelcomeScreen";
    private static final String NAME = "Check for Updates";
    private static final String PARENT_NAME = "Help";
    private final String thisVersion;
    private String latestVersion;
    private final CyServiceRegistrar serviceRegistrar;

    public CheckForUpdatesAction(CyServiceRegistrar serviceRegistrar) {
        super(NAME);
        this.setPreferredMenu(PARENT_NAME);
        this.setMenuGravity(9.999f);
        this.serviceRegistrar = serviceRegistrar;
        this.thisVersion = ((CyVersion)serviceRegistrar.getService(CyVersion.class)).getVersion();
    }

    public void actionPerformed(ActionEvent ae) {
        SwingUtilities.invokeLater(() -> this.showDialog(false));
    }

    public void handleEvent(CyStartEvent cyStartEvent) {
        final GetLatestVersionTask task = new GetLatestVersionTask();
        this.runTask((Task)task, new TaskObserver(){

            public void taskFinished(ObservableTask task2) {
            }

            public void allFinished(FinishStatus finishStatus) {
                if (finishStatus.getType() == FinishStatus.Type.SUCCEEDED) {
                    CheckForUpdatesAction.this.latestVersion = task.getLatestVersion();
                    boolean hide = false;
                    Properties props = CheckForUpdatesAction.this.getCyProperties();
                    if (CheckForUpdatesAction.this.latestVersion == null || CheckForUpdatesAction.this.latestVersion.isEmpty() || CheckForUpdatesAction.this.thisVersion.equals(CheckForUpdatesAction.this.latestVersion) || CheckForUpdatesAction.isPreRelease(CheckForUpdatesAction.this.thisVersion)) {
                        hide = true;
                    }
                    if (!hide) {
                        String hideVersion = props.getProperty(CheckForUpdatesAction.HIDE_UPDATES_PROP, "").trim();
                        boolean bl = hide = hideVersion.equalsIgnoreCase("true") || hideVersion.equals(CheckForUpdatesAction.this.latestVersion);
                    }
                    if (!hide) {
                        String tempHideString = props.getProperty(CheckForUpdatesAction.TEMP_HIDE_PROP);
                        hide = CheckForUpdatesAction.parseBoolean(tempHideString);
                    }
                    props.remove(CheckForUpdatesAction.TEMP_HIDE_PROP);
                    if (!hide) {
                        SwingUtilities.invokeLater(() -> CheckForUpdatesAction.this.showDialog(true));
                    }
                }
            }
        });
    }

    private void runTask(Task task, TaskObserver observer) {
        TaskIterator iterator = new TaskIterator(new Task[]{task});
        ((DialogTaskManager)this.serviceRegistrar.getService(DialogTaskManager.class)).execute(iterator, observer);
    }

    private static boolean isPreRelease(String version) {
        return version.contains("-");
    }

    private void showDialog(boolean hideOptionVisible) {
        JFrame owner = ((CySwingApplication)this.serviceRegistrar.getService(CySwingApplication.class)).getJFrame();
        UpdatesDialog dialog = new UpdatesDialog(owner, this.thisVersion, this.latestVersion, hideOptionVisible, this.serviceRegistrar);
        dialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setVisible(true);
        if (hideOptionVisible) {
            if (dialog.getHideStatus()) {
                this.getCyProperties().setProperty(HIDE_UPDATES_PROP, this.latestVersion);
            } else {
                this.getCyProperties().remove(HIDE_UPDATES_PROP);
            }
        }
    }

    private Properties getCyProperties() {
        return (Properties)((CyProperty)this.serviceRegistrar.getService(CyProperty.class, "(cyPropertyName=cytoscape3.props)")).getProperties();
    }

    private static boolean parseBoolean(String hideString) {
        boolean lhide = false;
        if (hideString == null) {
            lhide = false;
        } else {
            try {
                lhide = Boolean.parseBoolean(hideString);
            }
            catch (Exception ex) {
                lhide = false;
            }
        }
        return lhide;
    }
}

