/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.internal;

import java.awt.Desktop;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.SwingUtilities;
import org.cytoscape.application.CyShutdown;
import org.cytoscape.application.events.CyShutdownRequestedEvent;
import org.cytoscape.application.events.CyShutdownRequestedListener;
import org.cytoscape.internal.view.help.AboutDialog;
import org.cytoscape.service.util.AbstractCyActivator;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.osgi.framework.BundleContext;

public class MacCyActivator
extends AbstractCyActivator {
    private AboutDialog aboutDialog;

    public void start(BundleContext context) throws Exception {
        CyServiceRegistrar serviceRegistrar = (CyServiceRegistrar)this.getService(context, CyServiceRegistrar.class);
        CyShutdown shutdown = (CyShutdown)this.getService(context, CyShutdown.class);
        CyShutdownRequestedEvent[] lastShutdownEvent = new CyShutdownRequestedEvent[1];
        CyShutdownRequestedListener listener = evt -> {
            lastShutdownEvent[0] = evt;
        };
        this.registerService(context, listener, CyShutdownRequestedListener.class);
        Desktop desktop = Desktop.getDesktop();
        desktop.setQuitHandler((evt, response) -> {
            shutdown.exit(0);
            if (lastShutdownEvent[0] != null && !lastShutdownEvent[0].actuallyShutdown()) {
                response.cancelQuit();
            }
        });
        desktop.setAboutHandler(evt -> SwingUtilities.invokeLater(() -> {
            if (this.aboutDialog == null) {
                this.aboutDialog = new AboutDialog(serviceRegistrar);
                this.aboutDialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        MacCyActivator.this.aboutDialog = null;
                    }
                });
            }
            this.aboutDialog.pack();
            this.aboutDialog.setLocationRelativeTo(this.aboutDialog.getOwner());
            this.aboutDialog.setVisible(true);
        }));
    }
}

