/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.annotation.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollapsedStringAdapter
extends XmlAdapter<String, String> {
    @Override
    public String marshal(String v) {
        return v;
    }

    @Override
    public String unmarshal(String v) {
        int s;
        if (v == null) {
            return null;
        }
        int len = v.length();
        for (s = 0; s < len && !CollapsedStringAdapter.isWhiteSpace(v.charAt(s)); ++s) {
        }
        if (s == len) {
            return v;
        }
        StringBuffer result = new StringBuffer(len);
        if (s != 0) {
            for (int i = 0; i < s; ++i) {
                result.append(v.charAt(i));
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        for (int i = s + 1; i < len; ++i) {
            char ch = v.charAt(i);
            boolean b = CollapsedStringAdapter.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            result.append(inStripMode ? (char)' ' : (char)ch);
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    protected static boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }
}

