/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.scripting.internal;

import java.io.File;
import java.io.FileReader;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.cytoscape.app.CyAppAdapter;
import org.cytoscape.command.CommandExecutorTaskFactory;
import org.cytoscape.scripting.internal.AbstractExecuteScriptTask;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.ProvidesTitle;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.util.ListSingleSelection;

public class ExecuteScriptTask
extends AbstractExecuteScriptTask {
    private static final String CYCOMMAND_TITLE = "Cytoscape Commands";
    @Tunable(description="Script File Name:", params="fileCategory=SCRIPT;input=true")
    public File file;
    @Tunable(description="Select Script Type:")
    public ListSingleSelection<String> engineNames;

    @ProvidesTitle
    public String getTitle() {
        return "Run Script File";
    }

    ExecuteScriptTask(ScriptEngineManager manager, CyServiceRegistrar serviceRegistrar) {
        super(manager, serviceRegistrar);
        this.engineNameList.add(CYCOMMAND_TITLE);
        this.engineNames = new ListSingleSelection(this.engineNameList);
        this.engineNames.setSelectedValue((Object)((String)this.engineNameList.get(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor taskMonitor) throws Exception {
        String selected = (String)this.engineNames.getSelectedValue();
        if (selected == CYCOMMAND_TITLE) {
            this.executeCyCommandFile();
            return;
        }
        ScriptEngineFactory engineFactory = (ScriptEngineFactory)this.name2engineMap.get(this.engineNames.getSelectedValue());
        ScriptEngine engine = engineFactory.getScriptEngine();
        engine.put("cyAppAdapter", this.serviceRegistrar.getService(CyAppAdapter.class));
        FileReader reader = null;
        try {
            reader = new FileReader(this.file);
            engine.eval(reader);
        }
        finally {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
    }

    private void executeCyCommandFile() throws Exception {
        CommandExecutorTaskFactory taskFactory = (CommandExecutorTaskFactory)this.serviceRegistrar.getService(CommandExecutorTaskFactory.class);
        TaskIterator cyCommandTasks = taskFactory.createTaskIterator(this.file, null);
        this.insertTasksAfterCurrentTask(cyCommandTasks);
    }
}

