/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.plugin;

import java.util.ArrayList;
import java.util.List;

public class MITABLine25 {
    private static final char COLON = ':';
    private static final char PIPE = '|';
    private static final char TAB = '\t';
    private static final char QUOTE = '\"';
    String sourceRawID = "";
    String targetRawID = "";
    final List<String> srcAliases = new ArrayList<String>(10);
    final List<String> srcDBs = new ArrayList<String>(10);
    final List<String> tgtAliases = new ArrayList<String>(10);
    final List<String> tgtDBs = new ArrayList<String>(10);
    final List<String> authors = new ArrayList<String>(5);
    final List<String> detectionMethods = new ArrayList<String>(5);
    final List<String> detectionDBs = new ArrayList<String>(5);
    final List<String> publicationValues = new ArrayList<String>(5);
    final List<String> publicationDBs = new ArrayList<String>(5);
    final List<String> srcTaxonDBs = new ArrayList<String>(5);
    final List<String> srcTaxonIDs = new ArrayList<String>(5);
    final List<String> tgtTaxonDBs = new ArrayList<String>(5);
    final List<String> tgtTaxonIDs = new ArrayList<String>(5);
    final List<String> sourceIDs = new ArrayList<String>(5);
    final List<String> sourceDBs = new ArrayList<String>(5);
    final List<String> interactionTypes = new ArrayList<String>(5);
    final List<String> interactionTypeDBs = new ArrayList<String>(5);
    final List<String> edgeScoreTypes = new ArrayList<String>(5);
    final List<String> edgeScoreStrings = new ArrayList<String>(5);
    final List<String> interactionIDs = new ArrayList<String>(5);
    List<String> interactionDBs = new ArrayList<String>(5);
    private int colon = 0;
    private int tab = 0;
    private int pipe = 0;
    private int begin = 0;
    private int end = 0;

    private void init() {
        this.sourceRawID = "";
        this.targetRawID = "";
        this.colon = 0;
        this.tab = 0;
        this.pipe = 0;
        this.begin = 0;
        this.end = 0;
        this.srcAliases.clear();
        this.tgtAliases.clear();
        this.authors.clear();
        this.detectionMethods.clear();
        this.detectionDBs.clear();
        this.publicationDBs.clear();
        this.publicationValues.clear();
        this.srcTaxonIDs.clear();
        this.srcTaxonDBs.clear();
        this.tgtTaxonIDs.clear();
        this.tgtTaxonDBs.clear();
        this.sourceIDs.clear();
        this.sourceDBs.clear();
        this.interactionTypes.clear();
        this.interactionTypeDBs.clear();
        this.edgeScoreTypes.clear();
        this.edgeScoreStrings.clear();
        this.interactionIDs.clear();
        this.interactionDBs.clear();
    }

    public void readLine(String line) {
        this.init();
        int firstDelimiterIdx = line.indexOf(9);
        int secondDelimiterIdx = line.indexOf(9, firstDelimiterIdx + 1);
        String primarySourceId = line.substring(0, firstDelimiterIdx);
        String primaryTargetId = line.substring(firstDelimiterIdx, secondDelimiterIdx);
        this.srcDBs.add(this.nextString(line));
        this.sourceRawID = this.nextString(line);
        this.srcAliases.add(this.sourceRawID);
        if (primarySourceId.indexOf(124) != -1) {
            this.addNextPairs("additional src aliases", this.srcDBs, this.srcAliases, line);
        }
        this.tgtDBs.add(this.nextString(line));
        this.targetRawID = this.nextString(line);
        this.tgtAliases.add(this.targetRawID);
        if (primaryTargetId.indexOf(124) != -1) {
            this.addNextPairs("additional tgt aliases", this.tgtDBs, this.tgtAliases, line);
        }
        this.addNextPairs("col 2 src", this.srcDBs, this.srcAliases, line);
        this.addNextPairs("col 3 tgt", this.tgtDBs, this.tgtAliases, line);
        this.addNextPairs("col 4 src", this.srcDBs, this.srcAliases, line);
        this.addNextPairs("col 5 tgt", this.tgtDBs, this.tgtAliases, line);
        this.addNextPairs("detection", this.detectionDBs, this.detectionMethods, line);
        this.addNextValues("authors", this.authors, line);
        this.addNextPairs("publications", this.publicationDBs, this.publicationValues, line);
        this.addNextPairs("src taxon", this.srcTaxonDBs, this.srcTaxonIDs, line);
        this.addNextPairs("tgt taxon", this.tgtTaxonDBs, this.tgtTaxonIDs, line);
        this.addNextPairs("interaction", this.interactionTypeDBs, this.interactionTypes, line);
        this.addNextPairs("source", this.sourceDBs, this.sourceIDs, line);
        this.addNextPairs("interaction IDs", this.interactionDBs, this.interactionIDs, line);
        this.addNextPairs("edge scores", this.edgeScoreTypes, this.edgeScoreStrings, line);
    }

    public void print() {
        System.out.println("sourceRawID: " + this.sourceRawID);
        System.out.println("targetRawID: " + this.targetRawID);
        this.printList("srcAliases", this.srcAliases);
        this.printList("tgtAliases", this.tgtAliases);
        this.printList("detectionDBs", this.detectionDBs);
        this.printList("detectionMethods", this.detectionMethods);
        this.printList("authors", this.authors);
        this.printList("publicationDBs", this.publicationDBs);
        this.printList("publicationValues", this.publicationValues);
        this.printList("sourceDBs", this.sourceDBs);
        this.printList("sourceIDs", this.sourceIDs);
        this.printList("interactionTypes", this.interactionTypes);
        this.printList("interactionTypeDBs", this.interactionTypeDBs);
        this.printList("interactionIDs", this.interactionIDs);
        this.printList("interactionDBs", this.interactionDBs);
        this.printList("edgeScoreTypes", this.edgeScoreTypes);
        this.printList("edgeScoreStrings", this.edgeScoreStrings);
        System.out.println();
        System.out.println();
    }

    public void printList(String name, List<String> vals) {
        System.out.print(name + ": ");
        for (String s : vals) {
            System.out.print("'" + s + "', ");
        }
        System.out.println();
    }

    private String nextString(String line) {
        int closeQuote;
        this.end = this.nextIndex(line, this.begin);
        if (this.begin > this.end || this.begin > line.length() - 1) {
            return "";
        }
        String ret = line.substring(this.begin, this.end);
        int openQuote = ret.indexOf(34);
        if (openQuote >= 0 && (closeQuote = ret.indexOf(34, openQuote + 1)) < 0) {
            this.end = this.nextIndex(line, this.end + 1);
            ret = line.substring(this.begin, this.end);
        }
        this.begin = this.end + 1;
        return ret;
    }

    private void addNextValues(String desc, List<String> values, String line) {
        do {
            this.authors.add(this.nextString(line));
        } while (this.end != this.tab);
    }

    private void addNextPairs(String desc, List<String> dbs, List<String> values, String line) {
        do {
            String db;
            if ((db = this.nextString(line)).equals("") || db.equals("-")) {
                return;
            }
            dbs.add(db);
            String val = this.nextString(line);
            values.add(val);
        } while (this.end != this.tab);
    }

    private int nextIndex(String s, int start) {
        this.colon = s.indexOf(58, start);
        if (this.colon < 0) {
            this.colon = s.length() - 1;
        }
        this.pipe = s.indexOf(124, start);
        if (this.pipe < 0) {
            this.pipe = s.length() - 1;
        }
        this.tab = s.indexOf(9, start);
        if (this.tab < 0) {
            this.tab = s.length() - 1;
        }
        int ind = Math.min(this.colon, Math.min(this.pipe, this.tab));
        return ind;
    }

    private int peekNextIndex(String s, int start) {
        int y;
        int z = 0;
        int x = s.indexOf(58, start);
        if (x < 0) {
            x = s.length() - 1;
        }
        if ((y = s.indexOf(124, start)) < 0) {
            y = s.length() - 1;
        }
        if ((z = s.indexOf(9, start)) < 0) {
            z = s.length() - 1;
        }
        int ind = Math.min(x, Math.min(y, z));
        return ind;
    }
}

