/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.data_mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import psidev.psi.mi.xml.model.Alias;
import psidev.psi.mi.xml.model.Attribute;
import psidev.psi.mi.xml.model.Entry;
import psidev.psi.mi.xml.model.EntrySet;
import psidev.psi.mi.xml.model.ExperimentDescription;
import psidev.psi.mi.xml.model.Interaction;
import psidev.psi.mi.xml.model.InteractionType;
import psidev.psi.mi.xml.model.Interactor;
import psidev.psi.mi.xml.model.InteractorType;
import psidev.psi.mi.xml.model.Names;
import psidev.psi.mi.xml.model.Organism;
import psidev.psi.mi.xml.model.Participant;
import psidev.psi.mi.xml.model.Source;

public class PSIMI25EntryMapper {
    private static final String NAME_FULL = "Full Name";
    private static final String NAME_SHORT = "Short Label";
    private static final String INTERACTOR_TYPE = "Interactor Type";
    private static final String TAX_ID = "Species (NCBI TAX ID)";
    private static final String INTERACTION_TYPE = "Interaction Type";
    private final EntrySet es;
    private final CyNetwork network;
    private final Map<Integer, CyNode> id2NodeMap;
    private boolean cancelFlag = false;

    public PSIMI25EntryMapper(CyNetwork network, EntrySet es) {
        this.es = es;
        this.network = network;
        this.id2NodeMap = new HashMap<Integer, CyNode>();
    }

    public void map() {
        Collection entries = this.es.getEntries();
        for (Entry entry : entries) {
            this.mapNetworkMetaData(entry);
            this.mapNodes(entry.getInteractors());
            this.mapEdges(entry.getInteractions());
        }
    }

    private void mapNetworkMetaData(Entry entry) {
        CyTable networkTable = this.network.getDefaultNetworkTable();
        Collection attrs = entry.getAttributes();
        Collection exp = entry.getExperiments();
        Source source = entry.getSource();
        this.mapSource(source, networkTable);
        entry.getAvailabilities();
    }

    private void mapSource(Source source, CyTable networkTable) {
        Names names = source.getNames();
        this.mapNames(networkTable, this.network.getSUID(), names, "Network Source ");
        source.getBibref();
    }

    private void mapNames(CyTable table, Long suid, Names names, String prefix) {
        String fullName;
        Object fullNameLabel;
        Object shortNameLael;
        if (names == null) {
            return;
        }
        String shortName = names.getShortLabel();
        Collection aliases = names.getAliases();
        if (prefix != null) {
            shortNameLael = prefix + NAME_SHORT;
            fullNameLabel = prefix + NAME_FULL;
        } else {
            shortNameLael = NAME_SHORT;
            fullNameLabel = NAME_FULL;
        }
        if (shortName != null) {
            if (table.getColumn((String)shortNameLael) == null) {
                table.createColumn((String)shortNameLael, String.class, false);
            }
            table.getRow((Object)suid).set((String)shortNameLael, (Object)shortName);
        }
        if ((fullName = names.getFullName()) != null) {
            if (table.getColumn((String)fullNameLabel) == null) {
                table.createColumn((String)fullNameLabel, String.class, false);
            }
            table.getRow((Object)suid).set((String)fullNameLabel, (Object)fullName);
        }
        for (Alias alias : aliases) {
            String type = alias.getType();
            String val = alias.getValue();
            if (table.getColumn(type) == null) {
                table.createColumn(type, String.class, false);
            }
            table.getRow((Object)suid).set(type, (Object)val);
        }
    }

    private void mapExperiments(Collection<ExperimentDescription> exp, CyTable networkTable) {
        int expCount = 1;
        for (ExperimentDescription desc : exp) {
            String prefix = "Experiment " + expCount + ": ";
            Names names = desc.getNames();
            this.mapNames(networkTable, this.network.getSUID(), names, prefix);
            ++expCount;
        }
    }

    private void mapNodes(Collection<Interactor> interactors) {
        CyTable nodeTable = this.network.getDefaultNodeTable();
        if (nodeTable.getColumn(INTERACTOR_TYPE) == null) {
            nodeTable.createColumn(INTERACTOR_TYPE, String.class, false);
        }
        if (nodeTable.getColumn(TAX_ID) == null) {
            nodeTable.createColumn(TAX_ID, String.class, false);
        }
        for (Interactor interactor : interactors) {
            Organism org;
            if (this.cancelFlag) {
                return;
            }
            int id = interactor.getId();
            CyNode node = this.network.addNode();
            String nameColumn = interactor.getNames().getShortLabel();
            nodeTable.getRow((Object)node.getSUID()).set("name", (Object)nameColumn);
            InteractorType itrType = interactor.getInteractorType();
            Names typeNames = itrType.getNames();
            if (typeNames != null) {
                String shortName = typeNames.getShortLabel();
                nodeTable.getRow((Object)node.getSUID()).set(INTERACTOR_TYPE, (Object)shortName);
            }
            if ((org = interactor.getOrganism()) != null) {
                Integer taxID = org.getNcbiTaxId();
                this.mapNames(nodeTable, node.getSUID(), org.getNames(), "Species ");
                if (taxID != null) {
                    nodeTable.getRow((Object)node.getSUID()).set(TAX_ID, (Object)Integer.toString(taxID));
                }
            }
            this.mapNames(nodeTable, node.getSUID(), interactor.getNames(), null);
            this.mapAttributes(interactor.getAttributes(), nodeTable, node.getSUID());
            this.id2NodeMap.put(id, node);
        }
    }

    private void mapEdges(Collection<Interaction> interactions) {
        CyTable edgeTable = this.network.getDefaultEdgeTable();
        CyTable nodeTable = this.network.getDefaultNodeTable();
        if (edgeTable.getColumn(INTERACTION_TYPE) == null) {
            edgeTable.createListColumn(INTERACTION_TYPE, String.class, false);
        }
        for (Interaction interaction : interactions) {
            if (this.cancelFlag) {
                return;
            }
            Collection nodes = interaction.getParticipants();
            if (nodes.size() == 2) {
                Iterator itr = nodes.iterator();
                Participant source = (Participant)itr.next();
                Participant target = (Participant)itr.next();
                this.processEdge(source, target, interaction, nodes, nodeTable, edgeTable);
                continue;
            }
            this.createSpokeModel(interaction, nodes, nodeTable, edgeTable);
        }
    }

    private void createSpokeModel(Interaction interaction, Collection<Participant> nodes, CyTable nodeTable, CyTable edgeTable) {
        Participant hub = nodes.iterator().next();
        for (Participant target : nodes) {
            if (hub == target) continue;
            this.processEdge(hub, target, interaction, nodes, nodeTable, edgeTable);
        }
    }

    private void processEdge(Participant source, Participant target, Interaction interaction, Collection<Participant> nodes, CyTable nodeTable, CyTable edgeTable) {
        Interactor sourceInteractor = source.getInteractor();
        Interactor targetInteractor = target.getInteractor();
        if (sourceInteractor == null || targetInteractor == null) {
            return;
        }
        CyNode sourceCyNode = this.id2NodeMap.get(sourceInteractor.getId());
        CyNode targetCyNode = this.id2NodeMap.get(targetInteractor.getId());
        CyEdge edge = this.network.addEdge(sourceCyNode, targetCyNode, false);
        edgeTable.getRow((Object)edge.getSUID()).set("interaction", (Object)"pp");
        String sourceName = (String)nodeTable.getRow((Object)sourceCyNode.getSUID()).get("name", String.class);
        String targetName = (String)nodeTable.getRow((Object)targetCyNode.getSUID()).get("name", String.class);
        edgeTable.getRow((Object)edge.getSUID()).set("name", (Object)(sourceName + " (pp) " + targetName));
        this.mapNames(edgeTable, edge.getSUID(), interaction.getNames(), null);
        this.mapAttributes(interaction.getAttributes(), edgeTable, edge.getSUID());
        Collection types = interaction.getInteractionTypes();
        this.mapInteractionType(types, edgeTable, edge.getSUID());
    }

    private void mapInteractionType(Collection<InteractionType> types, CyTable table, Long suid) {
        if (types == null) {
            return;
        }
        ArrayList<String> typeList = new ArrayList<String>();
        for (InteractionType type : types) {
            String label = type.getNames().getShortLabel();
            typeList.add(label);
        }
        table.getRow((Object)suid).set(INTERACTION_TYPE, typeList);
    }

    private void mapAttributes(Collection<Attribute> attrs, CyTable table, Long suid) {
        for (Attribute attr : attrs) {
            CyRow row;
            ArrayList<String> list;
            String name = attr.getName();
            if (table.getColumn(name) == null) {
                table.createListColumn(name, String.class, false);
            }
            if ((list = (row = table.getRow((Object)suid)).getList(name, String.class)) == null) {
                list = new ArrayList<String>();
            }
            String nameAc = attr.getNameAc();
            String value = attr.getValue();
            list.add(value);
            row.set(name, list);
        }
    }

    private void mapXref() {
    }

    public void cancel() {
        this.cancelFlag = true;
    }
}

