/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.data_mapper;

import org.cytoscape.psi_mi.internal.data_mapper.MapperException;
import org.cytoscape.psi_mi.internal.model.ExternalReference;
import org.cytoscape.psi_mi.internal.schema.mi1.ProteinInteractorType;
import org.cytoscape.psi_mi.internal.schema.mi25.InteractorElementType;
import org.cytoscape.psi_mi.internal.schema.mi25.NamesType;

public class MapperUtil {
    public static String extractName(InteractorElementType interactor, ExternalReference[] refs) throws MapperException {
        String shortLabel = null;
        String fullName = null;
        NamesType names = interactor.getNames();
        if (names != null) {
            shortLabel = names.getShortLabel();
            fullName = names.getFullName();
        }
        if (shortLabel != null && shortLabel.trim().length() > 0) {
            return shortLabel;
        }
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                String dbName = refs[i].getDatabase();
                if (!dbName.equals("SWP") && !dbName.equals("SWISS-PROT") && !dbName.equalsIgnoreCase("SwissProt") && !dbName.equalsIgnoreCase("UniProt")) continue;
                return refs[i].getId();
            }
        }
        if (fullName != null && fullName.trim().length() > 0) {
            return fullName;
        }
        if ("" + interactor.getId() != null && ("" + interactor.getId()).trim().length() > 0) {
            return "" + interactor.getId();
        }
        throw new MapperException("Unable to determine namefor interactor:  " + interactor.getId());
    }

    public static String extractName(ProteinInteractorType interactor, ExternalReference[] refs) throws MapperException {
        String shortLabel = null;
        String fullName = null;
        org.cytoscape.psi_mi.internal.schema.mi1.NamesType names = interactor.getNames();
        if (names != null) {
            shortLabel = names.getShortLabel();
            fullName = names.getFullName();
        }
        if (shortLabel != null && shortLabel.trim().length() > 0) {
            return shortLabel;
        }
        if (refs != null) {
            for (int i = 0; i < refs.length; ++i) {
                String dbName = refs[i].getDatabase();
                if (!dbName.equals("SWP") && !dbName.equals("SWISS-PROT") && !dbName.equalsIgnoreCase("SwissProt") && !dbName.equalsIgnoreCase("UniProt")) continue;
                return refs[i].getId();
            }
        }
        if (fullName != null && fullName.trim().length() > 0) {
            return fullName;
        }
        if (interactor.getId() != null && interactor.getId().trim().length() > 0) {
            return interactor.getId();
        }
        throw new MapperException("Unable to determine namefor interactor:  " + interactor.getId());
    }

    public static String normalizeText(String text) {
        StringBuilder builder = new StringBuilder();
        int lastNonSpaceIndex = 0;
        boolean processingLeadingSpace = true;
        for (int i = 0; i < text.length(); ++i) {
            char character = text.charAt(i);
            boolean isWhitespace = Character.isWhitespace(character);
            if (processingLeadingSpace && isWhitespace) continue;
            if (processingLeadingSpace && !isWhitespace) {
                processingLeadingSpace = false;
                builder.append(character);
                lastNonSpaceIndex = i;
                continue;
            }
            if (!isWhitespace && i - lastNonSpaceIndex > 1) {
                builder.append(" ");
            }
            if (isWhitespace) continue;
            lastNonSpaceIndex = i;
            builder.append(character);
        }
        return builder.toString();
    }

    public static void main(String[] args) {
        for (String string : new String[]{"", " a", "   b", "c", "d ", "d   ", "   e   ", "f f", "g   g", "   h   h   "}) {
            System.out.printf("[%s]\n", MapperUtil.normalizeText(string));
        }
    }
}

