/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.data_mapper;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.cytoscape.psi_mi.internal.data_mapper.Mapper;
import org.cytoscape.psi_mi.internal.data_mapper.MapperException;
import org.cytoscape.psi_mi.internal.data_mapper.MapperUtil;
import org.cytoscape.psi_mi.internal.model.ExternalReference;
import org.cytoscape.psi_mi.internal.model.Interaction;
import org.cytoscape.psi_mi.internal.model.Interactor;
import org.cytoscape.psi_mi.internal.schema.mi1.BibrefType;
import org.cytoscape.psi_mi.internal.schema.mi1.CvType;
import org.cytoscape.psi_mi.internal.schema.mi1.DbReferenceType;
import org.cytoscape.psi_mi.internal.schema.mi1.EntrySet;
import org.cytoscape.psi_mi.internal.schema.mi1.ExperimentType;
import org.cytoscape.psi_mi.internal.schema.mi1.InteractionElementType;
import org.cytoscape.psi_mi.internal.schema.mi1.NamesType;
import org.cytoscape.psi_mi.internal.schema.mi1.ProteinInteractorType;
import org.cytoscape.psi_mi.internal.schema.mi1.ProteinParticipantType;
import org.cytoscape.psi_mi.internal.schema.mi1.RefType;
import org.cytoscape.psi_mi.internal.schema.mi1.XrefType;

public class MapPsiOneToInteractions
implements Mapper {
    private Map<String, ProteinInteractorType> interactorMap;
    private Map<String, ExperimentType> experimentMap;
    private List<Interaction> interactions;
    private String xml;

    public MapPsiOneToInteractions(String xml, List<Interaction> interactions) {
        this.xml = xml;
        this.interactions = interactions;
    }

    @Override
    public void doMapping() throws MapperException {
        this.parseXml(this.xml);
    }

    private void parseXml(String content) throws MapperException {
        try {
            this.interactorMap = new HashMap<String, ProteinInteractorType>();
            this.experimentMap = new HashMap<String, ExperimentType>();
            StringReader reader = new StringReader(content);
            JAXBContext jc = JAXBContext.newInstance((String)"org.cytoscape.psi_mi.internal.schema.mi1", (ClassLoader)this.getClass().getClassLoader());
            Unmarshaller u = jc.createUnmarshaller();
            EntrySet entrySet = (EntrySet)u.unmarshal((Reader)reader);
            int entryCount = entrySet.getEntry().size();
            for (int i = 0; i < entryCount; ++i) {
                EntrySet.Entry entry = entrySet.getEntry().get(i);
                this.extractEntry(entry);
            }
        }
        catch (JAXBException e) {
            throw new MapperException(e, "PSI-MI XML File is invalid:  " + e.getMessage());
        }
    }

    private void extractEntry(EntrySet.Entry entry) throws MapperException {
        EntrySet.Entry.ExperimentList expList = entry.getExperimentList();
        this.extractExperimentList(expList);
        EntrySet.Entry.InteractorList interactorList = entry.getInteractorList();
        this.extractInteractorList(interactorList);
        EntrySet.Entry.InteractionList interactionList = entry.getInteractionList();
        this.extractInteractionList(interactionList);
    }

    private void extractExperimentList(EntrySet.Entry.ExperimentList expList) {
        if (expList != null) {
            for (ExperimentType expType : expList.getExperimentDescription()) {
                String id = expType.getId();
                this.experimentMap.put(id, expType);
            }
        }
    }

    private void extractInteractorList(EntrySet.Entry.InteractorList interactorList) {
        if (interactorList != null) {
            for (ProteinInteractorType cProtein : interactorList.getProteinInteractor()) {
                String id = cProtein.getId();
                this.interactorMap.put(id, cProtein);
            }
        }
    }

    private void extractInteractionList(EntrySet.Entry.InteractionList interactionList) throws MapperException {
        for (InteractionElementType cInteraction : interactionList.getInteraction()) {
            Interaction interaction = new Interaction();
            interaction.setInteractionId(cInteraction.getInteractionType().size());
            List<CvType> interactionTypes = cInteraction.getInteractionType();
            InteractionElementType.ParticipantList pList = cInteraction.getParticipantList();
            ArrayList<Interactor> interactorList = new ArrayList<Interactor>();
            HashMap<String, String> interactorRoles = new HashMap<String, String>();
            for (ProteinParticipantType participant : pList.getProteinParticipant()) {
                Interactor interactor = this.extractInteractorRefOrElement(participant);
                interactorList.add(interactor);
                String role = participant.getRole();
                if (role == null) continue;
                interactorRoles.put(interactor.getName(), role);
            }
            interaction.setInteractors(interactorList);
            List<Interaction> list = this.extractExperimentalData(cInteraction, interaction);
            for (Interaction interaction2 : list) {
                interaction2.addAttribute("BAIT_MAP", interactorRoles);
                this.extractInteractionNamesXrefs(cInteraction, interaction2);
                this.addInteractorType(interactionTypes, interaction2);
            }
            this.interactions.addAll(list);
        }
    }

    private void addInteractorType(List<CvType> interactionTypes, Interaction interaction) {
        String shortName;
        CvType interactionType;
        NamesType namesType;
        if (interactionTypes != null && interactionTypes.size() == 1 && (namesType = (interactionType = interactionTypes.get(0)).getNames()) != null && (shortName = namesType.getShortLabel()) != null) {
            interaction.addAttribute("INTERACTION_TYPE_NAME", shortName);
        }
    }

    private void extractInteractionNamesXrefs(InteractionElementType cInteraction, Interaction interaction) {
        XrefType xref;
        ExternalReference[] refs;
        NamesType names = cInteraction.getNames();
        if (names != null) {
            String shortLabel = names.getShortLabel();
            String fullName = names.getFullName();
            if (shortLabel != null) {
                interaction.addAttribute("INTERACTION_SHORT_NAME", shortLabel);
            }
            if (fullName != null) {
                interaction.addAttribute("INTERACTION_FULL_NAME", fullName);
            }
        }
        if ((refs = this.extractExternalRefs(xref = cInteraction.getXref())) != null && refs.length > 0) {
            interaction.setExternalRefs(refs);
        }
    }

    private Interactor extractInteractorRefOrElement(ProteinParticipantType participant) throws MapperException {
        ProteinInteractorType cInteractor;
        Interactor interactor = null;
        RefType ref = participant.getProteinInteractorRef();
        if (ref != null) {
            String key = ref.getRef();
            cInteractor = this.interactorMap.get(key);
            if (cInteractor == null) {
                throw new MapperException("No Interactor Found for proteinInteractorRef:  " + key);
            }
        } else {
            cInteractor = participant.getProteinInteractor();
        }
        if (cInteractor != null) {
            interactor = this.createInteractor(cInteractor);
        }
        return interactor;
    }

    private void extractInteractorName(ProteinInteractorType cProtein, Interactor interactor) throws MapperException {
        NamesType names = cProtein.getNames();
        if (names != null) {
            String name = MapperUtil.normalizeText(MapperUtil.extractName(cProtein, interactor.getExternalRefs()));
            interactor.setName(name);
            String fullName = names.getFullName();
            interactor.addAttribute("FULL_NAME", fullName);
        }
    }

    private ExternalReference[] extractExternalRefs(XrefType xref) {
        ArrayList<ExternalReference> refList = new ArrayList<ExternalReference>();
        if (xref != null) {
            DbReferenceType primaryRef = xref.getPrimaryRef();
            if (primaryRef != null) {
                this.createExternalReference(primaryRef.getDb(), primaryRef.getId(), refList);
            }
            for (DbReferenceType secondaryRef : xref.getSecondaryRef()) {
                this.createExternalReference(secondaryRef.getDb(), secondaryRef.getId(), refList);
            }
            ExternalReference[] refs = new ExternalReference[refList.size()];
            refs = refList.toArray(refs);
            return refs;
        }
        return null;
    }

    private void createExternalReference(String db, String id, List<ExternalReference> refList) {
        ExternalReference ref = new ExternalReference(db, id);
        refList.add(ref);
    }

    private List<Interaction> extractExperimentalData(InteractionElementType cInteraction, Interaction interactionTemplate) throws MapperException {
        InteractionElementType.ExperimentList expList = cInteraction.getExperimentList();
        ArrayList<Interaction> list = new ArrayList<Interaction>();
        if (expList != null) {
            for (Object expItem : expList.getExperimentRefOrExperimentDescription()) {
                Interaction interaction = this.cloneInteractionTemplate(interactionTemplate);
                ExperimentType expType = this.extractExperimentReferenceOrElement(expItem);
                String id = this.getPubMedId(expType);
                if (id != null) {
                    interaction.addAttribute("PUB_MED_ID", id);
                }
                this.extractInteractionDetection(expType, interaction);
                list.add(interaction);
            }
        } else {
            throw new MapperException("Could not determine experimental data for one of the PSI-MI interactions");
        }
        return list;
    }

    private Interaction cloneInteractionTemplate(Interaction interactionTemplate) {
        Interaction interaction = new Interaction();
        List<Interactor> interactors = interactionTemplate.getInteractors();
        interaction.setInteractors(interactors);
        return interaction;
    }

    private ExperimentType extractExperimentReferenceOrElement(Object expItem) {
        if (expItem instanceof RefType) {
            RefType refType = (RefType)expItem;
            return this.experimentMap.get(refType.getRef());
        }
        return (ExperimentType)expItem;
    }

    private void extractInteractionDetection(ExperimentType expDesc, Interaction interaction) {
        CvType detection;
        String expSystem = null;
        if (expDesc != null && (detection = expDesc.getInteractionDetection()) != null) {
            DbReferenceType primaryRef;
            XrefType xref;
            NamesType names = detection.getNames();
            if (names != null && (expSystem = names.getShortLabel()) != null) {
                interaction.addAttribute("EXPERIMENTAL_SYSTEM_NAME", expSystem);
            }
            if ((xref = detection.getXref()) != null && (primaryRef = xref.getPrimaryRef()) != null) {
                interaction.addAttribute("EXPERIMENTAL_SYSTEM_XREF_DB", primaryRef.getDb());
                interaction.addAttribute("EXPERIMENTAL_SYSTEM_XREF_ID", primaryRef.getId());
            }
        }
    }

    private String getPubMedId(ExperimentType expDesc) {
        DbReferenceType primaryRef;
        XrefType xRef;
        BibrefType bibRef;
        String id = null;
        if (expDesc != null && (bibRef = expDesc.getBibref()) != null && (xRef = bibRef.getXref()) != null && (primaryRef = xRef.getPrimaryRef()) != null) {
            id = primaryRef.getId();
        }
        return id;
    }

    private Interactor createInteractor(ProteinInteractorType cProtein) throws MapperException {
        Interactor interactor = new Interactor();
        this.extractOrganismInfo(cProtein, interactor);
        this.extractSequenceData(cProtein, interactor);
        ExternalReference[] refs = this.extractExternalRefs(cProtein.getXref());
        if (refs != null && refs.length > 0) {
            interactor.setExternalRefs(refs);
        }
        String localId = cProtein.getId();
        interactor.addAttribute("LOCAL_ID", localId);
        this.extractInteractorName(cProtein, interactor);
        return interactor;
    }

    private void extractSequenceData(ProteinInteractorType cProtein, Interactor interactor) {
        String sequence = cProtein.getSequence();
        if (sequence != null) {
            interactor.addAttribute("SEQUENCE_DATA", sequence);
        }
    }

    private void extractOrganismInfo(ProteinInteractorType cProtein, Interactor interactor) {
        ProteinInteractorType.Organism organism = cProtein.getOrganism();
        if (organism != null) {
            NamesType names = organism.getNames();
            String commonName = names.getShortLabel();
            String fullName = names.getFullName();
            BigInteger ncbiTaxID = organism.getNcbiTaxId();
            if (commonName != null && commonName.length() > 0) {
                interactor.addAttribute("ORGANISM_COMMON_NAME", commonName);
            }
            if (fullName != null && fullName.length() > 0) {
                interactor.addAttribute("ORGANISM_SPECIES", fullName);
            }
            if (ncbiTaxID != null) {
                interactor.addAttribute("ORGANISM_NCBI_TAXON_ID", ncbiTaxID.toString());
            }
        }
    }
}

