/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.psi_mi.internal.cyto_mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNode;
import org.cytoscape.model.CyRow;
import org.cytoscape.psi_mi.internal.data_mapper.Mapper;
import org.cytoscape.psi_mi.internal.model.AttributeBag;
import org.cytoscape.psi_mi.internal.model.ExternalReference;
import org.cytoscape.psi_mi.internal.model.Interaction;
import org.cytoscape.psi_mi.internal.model.Interactor;

public class MapFromCytoscape
implements Mapper {
    private CyNetwork cyNetwork;
    private ArrayList<Interaction> interactions;

    public MapFromCytoscape(CyNetwork cyNetwork) {
        this.cyNetwork = cyNetwork;
    }

    @Override
    public void doMapping() {
        this.interactions = new ArrayList();
        for (CyEdge edge : this.cyNetwork.getEdgeList()) {
            Interaction interaction = new Interaction();
            if (edge == null) continue;
            CyNode sourceNode = edge.getSource();
            CyNode targetNode = edge.getTarget();
            Interactor sourceInteractor = new Interactor();
            Interactor targetInteractor = new Interactor();
            this.transferNodeAttributes(this.cyNetwork, sourceNode, sourceInteractor);
            this.transferNodeAttributes(this.cyNetwork, targetNode, targetInteractor);
            ArrayList<Interactor> interactors = new ArrayList<Interactor>();
            interactors.add(sourceInteractor);
            interactors.add(targetInteractor);
            interaction.setInteractors(interactors);
            this.transferEdgeAttributes(this.cyNetwork, edge, interaction);
            this.interactions.add(interaction);
        }
    }

    public ArrayList<Interaction> getInteractions() {
        return this.interactions;
    }

    private void transferEdgeAttributes(CyNetwork net, CyEdge edge, Interaction interaction) {
        this.transferAllAttributes(net.getRow((CyIdentifiable)edge), interaction);
    }

    private void transferNodeAttributes(CyNetwork net, CyNode node, Interactor interactor) {
        CyRow attributes = net.getRow((CyIdentifiable)node);
        interactor.setName((String)attributes.get("name", String.class));
        this.transferAllAttributes(attributes, interactor);
    }

    private void transferAllAttributes(CyRow attrs, AttributeBag bag) {
        List dbNames = null;
        List dbIds = null;
        for (Map.Entry entry : attrs.getAllValues().entrySet()) {
            String attributeName = (String)entry.getKey();
            Object value = entry.getValue();
            if (attributeName.equals("XREF_DB_NAME")) {
                dbNames = (List)value;
                continue;
            }
            if (attributeName.equals("XREF_DB_ID")) {
                dbIds = (List)value;
                continue;
            }
            if (!(value instanceof String)) continue;
            bag.addAttribute(attributeName, value);
        }
        this.addExternalReferences(dbNames, dbIds, bag);
    }

    private void addExternalReferences(List<String> dbNames, List<String> dbIds, AttributeBag bag) {
        if (dbNames != null && dbIds != null) {
            ExternalReference[] refs = new ExternalReference[dbNames.size()];
            for (int i = 0; i < dbNames.size(); ++i) {
                String dbName = dbNames.get(i);
                String dbId = dbIds.get(i);
                refs[i] = new ExternalReference(dbName, dbId);
            }
            bag.setExternalRefs(refs);
        }
    }
}

