/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.zoom;

import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.presentation.property.BasicVisualLexicon;
import org.cytoscape.work.undo.AbstractCyEdit;

final class ZoomEdit
extends AbstractCyEdit {
    private final CyNetworkView view;
    private final double factor;

    ZoomEdit(CyNetworkView view, double factor) {
        super(factor < 0.0 ? "Zoom Out" : "Zoom In");
        this.view = view;
        this.factor = factor;
    }

    public void redo() {
        double currentScaleFactor = (Double)this.view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)(currentScaleFactor * this.factor));
        this.view.updateView();
    }

    public void undo() {
        double currentScaleFactor = (Double)this.view.getVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR);
        this.view.setVisualProperty(BasicVisualLexicon.NETWORK_SCALE_FACTOR, (Object)(currentScaleFactor / this.factor));
        this.view.updateView();
    }
}

