/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.zoom;

import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.zoom.FitContentEdit;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.undo.AbstractCyEdit;
import org.cytoscape.work.undo.UndoSupport;

public class FitSelectedTask
extends AbstractTask {
    private final CyServiceRegistrar serviceRegistrar;
    CyNetworkView tunableView = null;

    @Tunable(description="Network View to export", longDescription="Specifies a network view by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network view.", exampleStringValue="current", context="nogui")
    public CyNetworkView getView() {
        return this.tunableView;
    }

    public void setView(CyNetworkView setView) {
        this.tunableView = setView;
    }

    public FitSelectedTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public FitSelectedTask(CyNetworkView view, CyServiceRegistrar serviceRegistrar) {
        this.tunableView = view;
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        tm.setTitle("Fit Selected");
        tm.setProgress(0.0);
        if (this.tunableView == null) {
            this.tunableView = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetworkView();
        }
        if (this.tunableView == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "No view to fit");
            return;
        }
        ((UndoSupport)this.serviceRegistrar.getService(UndoSupport.class)).postEdit((AbstractCyEdit)new FitContentEdit("Fit Selected", this.tunableView));
        tm.setProgress(0.3);
        this.tunableView.fitSelected();
        tm.setProgress(1.0);
    }
}

