/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.view;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class SetCurrentNetworkViewTask
extends AbstractTask {
    @Tunable(description="Network", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui")
    public CyNetwork network;
    @Tunable(description="View to set as the current view", longDescription="Specifies a network view by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network view.", exampleStringValue="current", context="nogui")
    public CyNetworkView view;
    private final CyServiceRegistrar serviceRegistrar;

    public SetCurrentNetworkViewTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("Set Current Network View");
        if (this.view == null) {
            List viewList;
            Collection<Object> collection = viewList = this.network != null ? ((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViews(this.network) : Collections.emptyList();
            if (!viewList.isEmpty()) {
                this.view = (CyNetworkView)viewList.iterator().next();
            }
        }
        tm.showMessage(TaskMonitor.Level.INFO, "Setting current view to " + this.view);
        ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).setCurrentNetworkView(this.view);
    }
}

