/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.util.json.CyJSONUtil;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class ListNetworkViewsTask
extends AbstractTask
implements ObservableTask {
    @Tunable(description="Network", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current", context="nogui")
    public CyNetwork network;
    private List<CyNetworkView> views;
    private final CyServiceRegistrar serviceRegistrar;

    public ListNetworkViewsTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        tm.setTitle("List Network Views");
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        this.views = new ArrayList<CyNetworkView>(((CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class)).getNetworkViews(this.network));
        tm.showMessage(TaskMonitor.Level.INFO, "Views for network " + (this.network != null ? DataUtils.getNetworkName(this.network) : null));
        Iterator<CyNetworkView> iterator = this.views.iterator();
        if (iterator.hasNext()) {
            CyNetworkView view = iterator.next();
            tm.showMessage(TaskMonitor.Level.INFO, "    " + view);
            return;
        }
    }

    public Object getResults(Class type) {
        if (type == String.class) {
            return DataUtils.convertData(this.views);
        }
        if (type == JSONResult.class) {
            String json = ((CyJSONUtil)this.serviceRegistrar.getService(CyJSONUtil.class)).cyIdentifiablesToJson(this.views);
            JSONResult res = () -> "{\"views\":" + json + "}";
            return res;
        }
        return this.views;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(List.class, String.class, JSONResult.class);
    }
}

