/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.view;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractNetworkViewCollectionTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.view.model.CyNetworkViewManager;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class DestroyNetworkViewTask
extends AbstractNetworkViewCollectionTask
implements ObservableTask {
    @Tunable(description="Deprecated", longDescription="Deprecated since version 3.6.", context="nogui")
    @Deprecated
    public boolean destroyCurrentNetworkView = true;
    @Tunable(description="<html>The selected views will be lost.<br />Do you want to continue?</html>", params="ForceSetDirectly=true;ForceSetTitle=Destroy Views", context="gui")
    public boolean confirm = true;
    private final Map<Long, String> destroyedSUIDs = new LinkedHashMap<Long, String>();
    private final CyServiceRegistrar serviceRegistrar;

    public DestroyNetworkViewTask(Collection<CyNetworkView> views, CyServiceRegistrar serviceRegistrar) {
        super(views);
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) {
        if (this.confirm && this.destroyCurrentNetworkView) {
            tm.setTitle("Destroy Network View(s)");
            tm.setProgress(0.0);
            CyNetworkViewManager viewManager = (CyNetworkViewManager)this.serviceRegistrar.getService(CyNetworkViewManager.class);
            int i = 0;
            int viewCount = this.networkViews.size();
            for (CyNetworkView nv : this.networkViews) {
                if (this.cancelled) {
                    return;
                }
                Long suid = nv.getSUID();
                String title = DataUtils.getViewTitle(nv);
                viewManager.destroyNetworkView(nv);
                this.destroyedSUIDs.put(suid, title);
                tm.setProgress((double)(++i) / (double)viewCount);
            }
            tm.setProgress(1.0);
        }
    }

    public Object getResults(Class type) {
        if (type == String.class) {
            StringBuilder sb = new StringBuilder();
            if (this.destroyedSUIDs != null && !this.destroyedSUIDs.isEmpty()) {
                sb.append("Destroyed views:\n");
                this.destroyedSUIDs.forEach((suid, title) -> sb.append(title + " (SUID: " + suid + ")\n"));
                sb.substring(0, sb.length() - 1);
            } else {
                sb.append("No views were destroyed.");
            }
            return sb.toString();
        }
        if (type == JSONResult.class) {
            JsonArray jsonArr = new JsonArray();
            JsonObject jsonObject = new JsonObject();
            if (this.destroyedSUIDs != null && !this.destroyedSUIDs.isEmpty()) {
                this.destroyedSUIDs.keySet().forEach(suid -> jsonArr.add((JsonElement)new JsonPrimitive((Number)suid)));
            }
            jsonObject.add("views", (JsonElement)jsonArr);
            String json = new Gson().toJson((JsonElement)jsonObject);
            JSONResult res = () -> json;
            return res;
        }
        return this.destroyedSUIDs != null ? new ArrayList<Long>(this.destroyedSUIDs.keySet()) : Collections.emptyList();
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, List.class, JSONResult.class);
    }
}

