/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.utils;

import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.work.Tunable;

public class TableTunable {
    private final CyServiceRegistrar serviceRegistrar;
    @Tunable(description="Table", context="nogui", longDescription="Specifies a table by table name. If the prefix ```SUID:``` is used, the table corresponding the SUID will be returned.", exampleStringValue="galFiltered.sif default node")
    public String table;

    public TableTunable(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public String getTableString() {
        return this.table;
    }

    public CyTable getTable() {
        if (this.table == null) {
            return null;
        }
        CyTableManager tableManager = (CyTableManager)this.serviceRegistrar.getService(CyTableManager.class);
        if (this.table.toLowerCase().startsWith("suid:")) {
            String[] tokens = this.table.split(":");
            CyTable t = tableManager.getTable(Long.parseLong(tokens[1].trim()));
            return t;
        }
        for (CyTable t : tableManager.getAllTables(true)) {
            if (!t.getTitle().equalsIgnoreCase(this.table)) continue;
            return t;
        }
        return null;
    }
}

