/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import org.cytoscape.application.CyApplicationManager;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.ColumnValueTunable;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;

public class SetNetworkAttributeTask
extends AbstractTableDataTask {
    @Tunable(description="Network", context="nogui", longDescription="Specifies a network by name, or by SUID if the prefix ```SUID:``` is used. The keyword ```CURRENT```, or a blank value can also be used to specify the current network.", exampleStringValue="current")
    public CyNetwork network;
    @ContainsTunables
    public ColumnValueTunable columnTunable = new ColumnValueTunable();

    public SetNetworkAttributeTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        if (this.network == null) {
            this.network = ((CyApplicationManager)this.serviceRegistrar.getService(CyApplicationManager.class)).getCurrentNetwork();
            if (this.network == null) {
                tm.showMessage(TaskMonitor.Level.ERROR, "Network must be specified");
                throw new RuntimeException("Network must be specified");
            }
        }
        CyTable networkTable = this.getNetworkTable(this.network, CyNetwork.class, this.columnTunable.getNamespace());
        int count = this.setCyIdentifierData(networkTable, (CyIdentifiable)this.network, this.columnTunable.getValueMap(networkTable));
        tm.showMessage(TaskMonitor.Level.INFO, "Set " + count + " network table values for network " + DataUtils.getNetworkName(this.network));
    }
}

