/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyEdge;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.ColumnValueTunable;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.EdgeTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class SetEdgeAttributeTask
extends AbstractTableDataTask
implements ObservableTask {
    @ContainsTunables
    public EdgeTunable edgeTunable;
    @ContainsTunables
    public ColumnValueTunable columnTunable;

    public SetEdgeAttributeTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.edgeTunable = new EdgeTunable(serviceRegistrar);
        this.columnTunable = new ColumnValueTunable();
    }

    public void run(TaskMonitor tm) {
        CyNetwork network = this.edgeTunable.getNetwork();
        CyTable edgeTable = this.getNetworkTable(network, CyEdge.class, this.columnTunable.getNamespace());
        for (CyEdge edge : this.edgeTunable.getEdgeList()) {
            int count = this.setCyIdentifierData(edgeTable, (CyIdentifiable)edge, this.columnTunable.getValueMap(edgeTable));
            tm.showMessage(TaskMonitor.Level.INFO, "   Set " + count + " edge table values for edge " + DataUtils.getEdgeName(edgeTable, edge));
        }
    }

    public Object getResults(Class type) {
        if (type.equals(JSONResult.class)) {
            JSONResult res = () -> "{}";
            return res;
        }
        return null;
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(JSONResult.class);
    }
}

