/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.task.internal.table.PrimaryKeyAndValue;

final class SaveColumn {
    final List<PrimaryKeyAndValue> keysAndValues;

    SaveColumn(CyTable table, String columnName) {
        this.keysAndValues = new ArrayList<PrimaryKeyAndValue>(table.getRowCount());
        String primarykeyName = table.getPrimaryKey().getName();
        for (CyRow row : table.getAllRows()) {
            Object primaryKey = row.getRaw(primarykeyName);
            Object value = row.getRaw(columnName);
            this.keysAndValues.add(new PrimaryKeyAndValue(primaryKey, value));
        }
    }

    void restoreColumn(CyTable table, String columnName) {
        for (PrimaryKeyAndValue keyAndValue : this.keysAndValues) {
            table.getRow(keyAndValue.getPrimaryKey()).set(columnName, keyAndValue.getValue());
        }
    }
}

