/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.edit.MergeTablesTaskFactory;
import org.cytoscape.task.internal.table.MapTableToNetworkTablesTask;
import org.cytoscape.task.internal.table.MergeTablesTask;
import org.cytoscape.work.AbstractTaskFactory;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class MergeTablesTaskFactoryImpl
extends AbstractTaskFactory
implements MergeTablesTaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public MergeTablesTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator() {
        return new TaskIterator(new Task[]{new MergeTablesTask(this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(CyTable sourceTable, CyTable targetTable, List<String> sourceColumnsList, String sourceKeyColumn, boolean mergeColumnVirtual, boolean mapToNetworks, boolean selectedNetworksOnly, List<CyNetwork> networkList, CyRootNetwork rootNetwork, CyColumn targetJoinColumn, Class<? extends CyIdentifiable> type) {
        ListSingleSelection targetTableList;
        MapTableToNetworkTablesTask.TableType tableType = this.getTableType(type);
        if (tableType == null) {
            throw new IllegalArgumentException("The specified type " + type + " is not acceptable.");
        }
        ListSingleSelection tableTypes = new ListSingleSelection((Object[])new MapTableToNetworkTablesTask.TableType[]{tableType});
        tableTypes.setSelectedValue((Object)tableType);
        ArrayList<String> networkNames = new ArrayList<String>();
        if (networkList != null) {
            for (CyNetwork net : networkList) {
                networkNames.add((String)net.getRow((CyIdentifiable)net).get("name", String.class));
            }
        }
        ListMultipleSelection networksListTunable = new ListMultipleSelection(networkNames);
        networksListTunable.setSelectedValues(networkNames);
        ArrayList<String> rootNetworkNames = new ArrayList<String>();
        ListSingleSelection rootNetworkList = new ListSingleSelection((Object[])new String[0]);
        if (rootNetwork != null) {
            rootNetworkNames.add((String)rootNetwork.getRow((CyIdentifiable)rootNetwork).get("name", String.class));
            rootNetworkList = new ListSingleSelection(rootNetworkNames);
            rootNetworkList.setSelectedValue((Object)((String)rootNetworkNames.get(0)));
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ListSingleSelection columnNamesList = new ListSingleSelection((Object[])new String[0]);
        if (targetJoinColumn != null) {
            columnNames.add(targetJoinColumn.getName());
            columnNamesList = new ListSingleSelection(columnNames);
            columnNamesList.setSelectedValue((Object)((String)columnNames.get(0)));
        }
        HashMap<String, Boolean> m = new HashMap<String, Boolean>();
        ListSingleSelection chooser = new ListSingleSelection((Object[])new String[]{"a network collection", "selected networks only", "an unassigned table"});
        if (mapToNetworks) {
            if (selectedNetworksOnly) {
                chooser.setSelectedValue((Object)"selected networks only");
            } else {
                chooser.setSelectedValue((Object)"a network collection");
            }
        } else {
            chooser.setSelectedValue((Object)"an unassigned table");
        }
        ListSingleSelection sourceTableList = new ListSingleSelection((Object[])new CyTable[]{sourceTable});
        sourceTableList.setSelectedValue((Object)sourceTable);
        if (targetTable != null) {
            targetTableList = new ListSingleSelection(new Object[]{targetTable});
            targetTableList.setSelectedValue((Object)targetTable);
        } else {
            targetTableList = new ListSingleSelection(new Object[]{"No Tables Found"});
            targetTableList.setSelectedValue((Object)"No Tables Found");
        }
        ListMultipleSelection sourceColNames = new ListMultipleSelection(sourceColumnsList);
        sourceColNames.setSelectedValues(sourceColumnsList);
        ListSingleSelection sourceColumn = new ListSingleSelection((Object[])new String[]{sourceKeyColumn});
        sourceColumn.setSelectedValue((Object)sourceKeyColumn);
        m.put("MergeType", mergeColumnVirtual);
        m.put("SourceMergeKey", (Boolean)sourceColumn);
        m.put("TargetMergeKey", (Boolean)columnNamesList);
        m.put("SourceTable", (Boolean)sourceTableList);
        m.put("UnassignedTable", (Boolean)targetTableList);
        m.put("SourceMergeColumns", (Boolean)sourceColNames);
        m.put("WhereMergeTable", (Boolean)chooser);
        m.put("TargetNetworkList", (Boolean)networksListTunable);
        m.put("TargetKeyNetworkCollection", (Boolean)columnNamesList);
        m.put("TargetNetworkCollection", (Boolean)rootNetworkList);
        m.put("DataTypeTargetForNetworkCollection", (Boolean)tableTypes);
        m.put("DataTypeTargetForNetworkList", (Boolean)tableTypes);
        return ((TunableSetter)this.serviceRegistrar.getService(TunableSetter.class)).createTaskIterator(this.createTaskIterator(), m);
    }

    private MapTableToNetworkTablesTask.TableType getTableType(Class<? extends CyIdentifiable> type) {
        if (type.equals(MapTableToNetworkTablesTask.TableType.GLOBAL.getType())) {
            return MapTableToNetworkTablesTask.TableType.GLOBAL;
        }
        if (type.equals(MapTableToNetworkTablesTask.TableType.EDGE_ATTR.getType())) {
            return MapTableToNetworkTablesTask.TableType.EDGE_ATTR;
        }
        if (type.equals(MapTableToNetworkTablesTask.TableType.NETWORK_ATTR.getType())) {
            return MapTableToNetworkTablesTask.TableType.NETWORK_ATTR;
        }
        if (type.equals(MapTableToNetworkTablesTask.TableType.NODE_ATTR.getType())) {
            return MapTableToNetworkTablesTask.TableType.NODE_ATTR;
        }
        return null;
    }
}

