/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.AbstractTableTaskFactory;
import org.cytoscape.task.edit.MapTableToNetworkTablesTaskFactory;
import org.cytoscape.task.internal.table.MapTableToNetworkTablesTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;

public final class MapTableToNetworkTablesTaskFactoryImpl
extends AbstractTableTaskFactory
implements MapTableToNetworkTablesTaskFactory {
    private final CyServiceRegistrar serviceRegistrar;

    public MapTableToNetworkTablesTaskFactoryImpl(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public TaskIterator createTaskIterator(CyTable globalTable) {
        return new TaskIterator(new Task[]{new MapTableToNetworkTablesTask(globalTable, this.serviceRegistrar)});
    }

    public TaskIterator createTaskIterator(CyTable globalTable, boolean selectedNetworksOnly, List<CyNetwork> networksList, Class<? extends CyIdentifiable> type) {
        MapTableToNetworkTablesTask.TableType tableType = this.getTableType(type);
        if (tableType == null) {
            throw new IllegalArgumentException("The specified type " + type + " is not acceptable.");
        }
        ListSingleSelection tableTypes = new ListSingleSelection((Object[])new MapTableToNetworkTablesTask.TableType[]{tableType});
        tableTypes.setSelectedValue((Object)tableType);
        ArrayList<String> networkNames = new ArrayList<String>();
        for (CyNetwork net : networksList) {
            networkNames.add((String)net.getRow((CyIdentifiable)net).get("name", String.class));
        }
        ListMultipleSelection networksListTunable = new ListMultipleSelection(networkNames);
        networksListTunable.setSelectedValues(networkNames);
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("dataTypeOptions", tableTypes);
        m.put("selectedNetworksOnly", selectedNetworksOnly);
        m.put("networkList", networksListTunable);
        return ((TunableSetter)this.serviceRegistrar.getService(TunableSetter.class)).createTaskIterator(this.createTaskIterator(globalTable), m);
    }

    private MapTableToNetworkTablesTask.TableType getTableType(Class<? extends CyIdentifiable> type) {
        if (type.equals(MapTableToNetworkTablesTask.TableType.GLOBAL.getType())) {
            return MapTableToNetworkTablesTask.TableType.GLOBAL;
        }
        if (type.equals(MapTableToNetworkTablesTask.TableType.EDGE_ATTR.getType())) {
            return MapTableToNetworkTablesTask.TableType.EDGE_ATTR;
        }
        if (type.equals(MapTableToNetworkTablesTask.TableType.NETWORK_ATTR.getType())) {
            return MapTableToNetworkTablesTask.TableType.NETWORK_ATTR;
        }
        if (type.equals(MapTableToNetworkTablesTask.TableType.NODE_ATTR.getType())) {
            return MapTableToNetworkTablesTask.TableType.NODE_ATTR;
        }
        return null;
    }
}

