/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyIdentifiable;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyNetworkManager;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.task.AbstractTableTaskFactory;
import org.cytoscape.task.edit.JoinTablesTaskTaskFactory;
import org.cytoscape.task.internal.table.JoinTablesTask;
import org.cytoscape.task.internal.table.MapTableToNetworkTablesTask;
import org.cytoscape.work.Task;
import org.cytoscape.work.TaskIterator;
import org.cytoscape.work.TunableSetter;
import org.cytoscape.work.util.ListMultipleSelection;
import org.cytoscape.work.util.ListSingleSelection;

public class JoinTablesTaskTaskFactoryImpl
extends AbstractTableTaskFactory
implements JoinTablesTaskTaskFactory {
    private final CyNetworkManager networkManager;
    private final TunableSetter tunableSetter;
    private final CyRootNetworkManager rootNetMgr;

    public JoinTablesTaskTaskFactoryImpl(CyNetworkManager networkManager, TunableSetter tunableSetter, CyRootNetworkManager rootNetMgr) {
        this.networkManager = networkManager;
        this.tunableSetter = tunableSetter;
        this.rootNetMgr = rootNetMgr;
    }

    public TaskIterator createTaskIterator(CyTable table) {
        return new TaskIterator(new Task[]{new JoinTablesTask(table, this.rootNetMgr, this.networkManager)});
    }

    public TaskIterator createTaskIterator(CyTable globalTable, boolean selectedNetworksOnly, List<CyNetwork> networkList, CyRootNetwork rootNetwork, CyColumn targetJoinColumn, Class<? extends CyIdentifiable> type) {
        MapTableToNetworkTablesTask.TableType tableType = this.getTableType(type);
        if (tableType == null) {
            throw new IllegalArgumentException("The specified type " + type + " is not acceptable.");
        }
        ListSingleSelection tableTypes = new ListSingleSelection((Object[])new MapTableToNetworkTablesTask.TableType[]{tableType});
        tableTypes.setSelectedValue((Object)tableType);
        ArrayList<String> networkNames = new ArrayList<String>();
        for (CyNetwork net : networkList) {
            networkNames.add((String)net.getRow((CyIdentifiable)net).get("name", String.class));
        }
        ListMultipleSelection networksListTunable = new ListMultipleSelection(networkNames);
        networksListTunable.setSelectedValues(networkNames);
        ArrayList<String> rootNetworkNames = new ArrayList<String>();
        ListSingleSelection rootNetworkList = new ListSingleSelection((Object[])new String[0]);
        if (rootNetwork != null) {
            rootNetworkNames.add((String)rootNetwork.getRow((CyIdentifiable)rootNetwork).get("name", String.class));
            rootNetworkList = new ListSingleSelection(rootNetworkNames);
            rootNetworkList.setSelectedValue((Object)((String)rootNetworkNames.get(0)));
        }
        ArrayList<String> columnNames = new ArrayList<String>();
        ListSingleSelection columnNamesList = new ListSingleSelection((Object[])new String[0]);
        if (targetJoinColumn != null) {
            columnNames.add(targetJoinColumn.getName());
            columnNamesList = new ListSingleSelection(columnNames);
            columnNamesList.setSelectedValue((Object)((String)columnNames.get(0)));
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("DataTypeOptions", tableTypes);
        m.put("SelectedNetworksOnly", selectedNetworksOnly);
        m.put("NetworkList", networksListTunable);
        m.put("ColumnList", columnNamesList);
        m.put("RootNetworkList", rootNetworkList);
        return this.tunableSetter.createTaskIterator(this.createTaskIterator(globalTable), m);
    }

    private MapTableToNetworkTablesTask.TableType getTableType(Class<? extends CyIdentifiable> type) {
        if (type.equals(MapTableToNetworkTablesTask.TableType.GLOBAL.getType())) {
            return MapTableToNetworkTablesTask.TableType.GLOBAL;
        }
        if (type.equals(MapTableToNetworkTablesTask.TableType.EDGE_ATTR.getType())) {
            return MapTableToNetworkTablesTask.TableType.EDGE_ATTR;
        }
        if (type.equals(MapTableToNetworkTablesTask.TableType.NETWORK_ATTR.getType())) {
            return MapTableToNetworkTablesTask.TableType.NETWORK_ATTR;
        }
        if (type.equals(MapTableToNetworkTablesTask.TableType.NODE_ATTR.getType())) {
            return MapTableToNetworkTablesTask.TableType.NODE_ATTR;
        }
        return null;
    }
}

