/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.List;
import org.cytoscape.model.CyTable;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.json.JSONResult;

public class DestroyTableTask
extends AbstractTableDataTask
implements ObservableTask {
    private long tableSUID = -1L;
    private String title;
    @ContainsTunables
    public TableTunable tableTunable;

    public DestroyTableTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.tableTunable = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        CyTable table = this.tableTunable.getTable();
        if (table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        this.tableSUID = table.getSUID();
        this.title = table.getTitle();
        String withId = this.title + " (suid:" + table.getSUID() + ")";
        ((CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).deleteTable(table.getSUID().longValue());
        tm.showMessage(TaskMonitor.Level.INFO, "Deleted table '" + withId + "'");
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return this.title;
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.tableSUID < 0L) {
                    return "{}";
                }
                return "{\"table\":" + this.tableSUID + "}";
            };
            return res;
        }
        return null;
    }
}

