/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.table;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.cytoscape.model.CyColumn;
import org.cytoscape.model.CyRow;
import org.cytoscape.model.CyTable;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.table.AbstractTableDataTask;
import org.cytoscape.task.internal.utils.DataUtils;
import org.cytoscape.task.internal.utils.TableTunable;
import org.cytoscape.work.ContainsTunables;
import org.cytoscape.work.ObservableTask;
import org.cytoscape.work.TaskMonitor;
import org.cytoscape.work.Tunable;
import org.cytoscape.work.json.JSONResult;

public class DeleteRowTask
extends AbstractTableDataTask
implements ObservableTask {
    CyRow row;
    CyTable table;
    @ContainsTunables
    public TableTunable tableTunable;
    @Tunable(description="Key value for row to delete", context="nogui", required=true, longDescription="Specifies the primary key of a value in the row of a table", exampleStringValue="BRCA")
    public String keyValue;

    public DeleteRowTask(CyServiceRegistrar serviceRegistrar) {
        super(serviceRegistrar);
        this.tableTunable = new TableTunable(serviceRegistrar);
    }

    public void run(TaskMonitor tm) {
        this.table = this.tableTunable.getTable();
        if (this.table == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to find table '" + this.tableTunable.getTableString() + "'");
            return;
        }
        if (this.keyValue == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Key of row to delete must be specified");
            return;
        }
        CyColumn primaryKColumn = this.table.getPrimaryKey();
        Class keyType = primaryKColumn.getType();
        Object key = null;
        try {
            key = DataUtils.convertString(this.keyValue, keyType);
        }
        catch (NumberFormatException nfe) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.keyValue + " to a " + keyType.getName() + ": " + nfe.getMessage());
            return;
        }
        if (key == null) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Unable to convert " + this.keyValue + " to a " + keyType.getName());
            return;
        }
        if (!this.table.rowExists(key)) {
            tm.showMessage(TaskMonitor.Level.ERROR, "Row " + this.keyValue + " doesn't exist");
            return;
        }
        this.table.deleteRows(Collections.singletonList(key));
        tm.showMessage(TaskMonitor.Level.INFO, "Deleted row '" + this.keyValue + "'");
    }

    public List<Class<?>> getResultClasses() {
        return Arrays.asList(String.class, JSONResult.class);
    }

    public Object getResults(Class requestedType) {
        if (requestedType.equals(String.class)) {
            return this.keyValue;
        }
        if (requestedType.equals(JSONResult.class)) {
            JSONResult res = () -> {
                if (this.table == null || this.keyValue == null) {
                    return "{}";
                }
                return "{\"table\":" + this.table.getSUID() + ",\"key\":\"" + this.keyValue + "\"}";
            };
            return res;
        }
        return null;
    }
}

