/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.session;

import java.io.File;
import org.cytoscape.event.CyEvent;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.io.util.RecentlyOpenedTracker;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.session.events.SessionSaveCancelledEvent;
import org.cytoscape.session.events.SessionSavedEvent;
import org.cytoscape.task.internal.session.CySessionWriter;
import org.cytoscape.work.AbstractTask;
import org.cytoscape.work.TaskMonitor;

public class SaveSessionTask
extends AbstractTask {
    private CySessionWriter writer;
    private final CyServiceRegistrar serviceRegistrar;

    public SaveSessionTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void run(TaskMonitor tm) throws Exception {
        CySession session = null;
        File file = null;
        CyEventHelper eventHelper = (CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class);
        try {
            CySessionManager sessionMgr = (CySessionManager)this.serviceRegistrar.getService(CySessionManager.class);
            tm.setProgress(0.05);
            session = sessionMgr.getCurrentSession();
            String fileName = sessionMgr.getCurrentSessionFileName();
            file = new File(fileName);
            this.writer = new CySessionWriter(session, file, this.serviceRegistrar);
            this.writer.run(tm);
            tm.setProgress(1.0);
            if (!file.getName().endsWith(".cys")) {
                file = new File(file.getPath() + ".cys");
            }
        }
        catch (Exception e) {
            eventHelper.fireEvent((CyEvent)new SessionSaveCancelledEvent((Object)this));
            throw e;
        }
        if (!this.cancelled) {
            eventHelper.fireEvent((CyEvent)new SessionSavedEvent((Object)this, session, file.getAbsolutePath()));
            ((RecentlyOpenedTracker)this.serviceRegistrar.getService(RecentlyOpenedTracker.class)).add(file.toURI().toURL());
        }
    }

    public void cancel() {
        super.cancel();
        if (this.writer != null) {
            this.writer.cancel();
        }
    }
}

