/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.session;

import java.util.HashSet;
import org.cytoscape.group.CyGroupManager;
import org.cytoscape.io.read.CySessionReader;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyTableManager;
import org.cytoscape.model.subnetwork.CyRootNetwork;
import org.cytoscape.model.subnetwork.CyRootNetworkManager;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.session.CySession;
import org.cytoscape.session.CySessionManager;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.AbstractTask;

public abstract class AbstractOpenSessionTask
extends AbstractTask {
    protected CySessionReader reader;
    protected final CyServiceRegistrar serviceRegistrar;

    protected AbstractOpenSessionTask(CyServiceRegistrar serviceRegistrar) {
        this.serviceRegistrar = serviceRegistrar;
    }

    public void cancel() {
        super.cancel();
        if (this.reader != null) {
            this.reader.cancel();
        }
    }

    protected void disposeCancelledSession(Exception e, CySessionManager sessionManager) {
        if (this.reader == null) {
            return;
        }
        CySession newSession = this.reader.getSession();
        if (newSession != null) {
            for (CyNetworkView view : newSession.getNetworkViews()) {
                view.dispose();
            }
            CyRootNetworkManager rootNetManager = (CyRootNetworkManager)this.serviceRegistrar.getService(CyRootNetworkManager.class);
            HashSet<CyRootNetwork> rootNetworks = new HashSet<CyRootNetwork>();
            for (CyNetwork net : newSession.getNetworks()) {
                rootNetworks.add(rootNetManager.getRootNetwork(net));
            }
            for (CyRootNetwork rootNet : rootNetworks) {
                rootNet.dispose();
            }
        }
        ((CyGroupManager)this.serviceRegistrar.getService(CyGroupManager.class)).reset();
        ((CyTableManager)this.serviceRegistrar.getService(CyTableManager.class)).reset();
        sessionManager.setCurrentSession(null, null);
    }
}

