/*
 * Decompiled with CFR 0.152.
 */
package org.cytoscape.task.internal.select;

import java.util.ArrayList;
import java.util.List;
import org.cytoscape.event.CyEventHelper;
import org.cytoscape.model.CyNetwork;
import org.cytoscape.model.CyRow;
import org.cytoscape.service.util.CyServiceRegistrar;
import org.cytoscape.task.internal.select.RowAndSelectionState;
import org.cytoscape.view.model.CyNetworkView;
import org.cytoscape.work.undo.AbstractCyEdit;

final class SelectionEdit
extends AbstractCyEdit {
    private List<RowAndSelectionState> nodeRows;
    private List<RowAndSelectionState> edgeRows;
    private final CyNetwork network;
    private final CyNetworkView view;
    private final SelectionFilter filter;
    private final CyServiceRegistrar serviceRegistrar;

    SelectionEdit(String description, CyNetwork network, CyNetworkView view, SelectionFilter filter, CyServiceRegistrar serviceRegistrar) {
        super(description);
        this.network = network;
        this.view = view;
        this.filter = filter;
        this.serviceRegistrar = serviceRegistrar;
        this.saveSelectionState();
    }

    public void redo() {
        this.saveAndRestoreState();
    }

    public void undo() {
        this.saveAndRestoreState();
    }

    private void saveAndRestoreState() {
        List<RowAndSelectionState> oldNodeRows = this.nodeRows;
        List<RowAndSelectionState> oldEdgeRows = this.edgeRows;
        this.saveSelectionState();
        if (this.filter == SelectionFilter.NODES_ONLY || this.filter == SelectionFilter.NODES_AND_EDGES) {
            for (RowAndSelectionState rowAndState : oldNodeRows) {
                rowAndState.getRow().set("selected", (Object)rowAndState.isSelected());
            }
        }
        if (this.filter == SelectionFilter.EDGES_ONLY || this.filter == SelectionFilter.NODES_AND_EDGES) {
            for (RowAndSelectionState rowAndState : oldEdgeRows) {
                rowAndState.getRow().set("selected", (Object)rowAndState.isSelected());
            }
        }
        ((CyEventHelper)this.serviceRegistrar.getService(CyEventHelper.class)).flushPayloadEvents();
        this.view.updateView();
    }

    private void saveSelectionState() {
        List rows;
        if (this.filter == SelectionFilter.NODES_ONLY || this.filter == SelectionFilter.NODES_AND_EDGES) {
            rows = this.network.getDefaultNodeTable().getAllRows();
            this.nodeRows = new ArrayList<RowAndSelectionState>(rows.size());
            for (CyRow row : rows) {
                this.nodeRows.add(new RowAndSelectionState(row, (Boolean)row.get("selected", Boolean.class)));
            }
        }
        if (this.filter == SelectionFilter.EDGES_ONLY || this.filter == SelectionFilter.NODES_AND_EDGES) {
            rows = this.network.getDefaultEdgeTable().getAllRows();
            this.edgeRows = new ArrayList<RowAndSelectionState>(rows.size());
            for (CyRow row : rows) {
                this.edgeRows.add(new RowAndSelectionState(row, (Boolean)row.get("selected", Boolean.class)));
            }
        }
    }

    public static enum SelectionFilter {
        NODES_ONLY,
        EDGES_ONLY,
        NODES_AND_EDGES;

    }
}

